<?xml version="1.0"?>
<sch:schema xmlns:sch="http://purl.oclc.org/dsdl/schematron">
  <sch:title>Rules for bibliography documents</sch:title>
  
  <!--
    Set of rules applying to the document fragments
  -->
  <sch:pattern>
    <sch:title>Fragments</sch:title>

    <sch:rule context="section/properties-fragment">

      <!-- Citations must have a cross-reference to a source -->
      <sch:assert id="CITATION_XREF"
                  test=".//xref"
                  diagnostics="fragment">
        Citation '<sch:value-of select="property[@name='link-text']/@value"/>' is incomplete
        - insert a cross-reference to the source.
      </sch:assert>

    </sch:rule>

  </sch:pattern>

  <sch:diagnostics>

    <sch:diagnostic id="fragment"><sch:value-of select="ancestor-or-self::properties-fragment/@id"/></sch:diagnostic>

  </sch:diagnostics>

</sch:schema>

