<!--
  ~ Copyright (c) 1999-2022. Allette Systems Pty Ltd
-->
<xsl:stylesheet version="2.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

  <xsl:param name="root-document-type" />

  <!-- add document label for publication root document type -->
  <xsl:template match="uri[@documenttype=$root-document-type]">
    <xsl:copy>
      <xsl:copy-of select="@*"/>
      <xsl:apply-templates select="*[not(name()='labels')]"/>
      <labels>
        <xsl:value-of select="$root-document-type"/>
        <xsl:if test="normalize-space(labels) != ''">
          <xsl:value-of select="concat(',',labels)" />
        </xsl:if>
      </labels>
    </xsl:copy>
  </xsl:template>

  <!-- only output alternate documents for footnotes, endnotes and source -->
  <xsl:template match="(xref|blockxref)[@type='alternate' and
                       not(@documenttype = ('footnotes','endnotes','source'))]">
    <xsl:copy>
      <xsl:apply-templates select="@*"/>
      <xsl:value-of select="if (@display='manual') then @title else @urititle" />
    </xsl:copy>
  </xsl:template>

  <!-- add fragment type as a fragment label - ->
  <xsl:template match="fragment[@type]">
    <xsl:copy>
      <xsl:copy-of select="@*[not(name()='labels')]"/>
      <xsl:attribute name="labels">
        <xsl:value-of select="translate(@type,'.','_')"/>
        <xsl:if test="normalize-space(@labels) != ''">
          <xsl:value-of select="concat(',',@labels)" />
        </xsl:if>
      </xsl:attribute>
      <xsl:apply-templates />
    </xsl:copy>
  </xsl:template> -->

  <!-- add inline labels at the start of figure caption so they can become fieldcodes -->
  <xsl:template match="para[@prefix and parent::block/@label='figure-caption']">
    <para>
      <xsl:value-of select="concat(substring-before(@prefix,' '),' ')"/>
      <inline label="figure-num-1"><xsl:value-of select="substring-after(substring-before(@prefix,'-'),' ')"/></inline>
      <xsl:text>-</xsl:text>
      <inline label="figure-num-2"><xsl:value-of select="substring-after(@prefix,'-')"/></inline>
      <xsl:text> </xsl:text>
      <xsl:apply-templates select="node()" />
    </para>
  </xsl:template>

  <!-- add inline labels at the start of table caption so they can become fieldcodes -->
  <xsl:template match="para[@prefix and parent::block/@label='table-caption']">
    <para>
      <xsl:value-of select="concat(substring-before(@prefix,' '),' ')"/>
      <inline label="table-num-1"><xsl:value-of select="substring-after(substring-before(@prefix,'-'),' ')"/></inline>
      <xsl:text>-</xsl:text>
      <inline label="table-num-2"><xsl:value-of select="substring-after(@prefix,'-')"/></inline>
      <xsl:text> </xsl:text>
      <xsl:apply-templates select="node()" />
    </para>
  </xsl:template>

  <!-- convert caption xref to manual as word can't autonumber these -->
  <xsl:template match="xref[@config='caption']">
    <xref display="manual" title="{.}">
      <xsl:copy-of select="@*[not(name()='display' or name()='title')]" />
      <xsl:apply-templates select="node()"/>
    </xref>
  </xsl:template>

  <!-- copy all other elements unchanged -->
  <xsl:template match="@*|node()">
    <xsl:copy>
      <xsl:apply-templates select="@*|node()"/>
    </xsl:copy>
  </xsl:template>

</xsl:stylesheet>