<?xml version="1.0"?>
<!--
  ~ Copyright (c) 1999-2023. Allette Systems Pty Ltd
  -->
<sch:schema xmlns:sch="http://purl.oclc.org/dsdl/schematron">
  <sch:title>Rules for defintion list</sch:title>

  <sch:let name="usage" value="document(concat(
                               'ps:search?filters=pstype:document,pspublicationid:',
                               /document/documentinfo/publication/@id,
                               '&amp;facets=psinline-definition&amp;facetsize=1000&amp;pagesize=1'))" />

  <!--
    Set of rules applying to usage
  -->
  <sch:pattern>
    <sch:title>Usage</sch:title>

    <sch:rule context="/">

      <sch:let name="terms"
               value="$usage//facets/facet/term" />

      <sch:report test="$terms">
        The following <sch:value-of select="count($terms)" />
        definitions are used in this publication:
        <sch:value-of select="string-join(sort($terms/@text,
                              'http://www.w3.org/2005/xpath-functions/collation/html-ascii-case-insensitive')
                              ,', ')"/>
      </sch:report>

    </sch:rule>

  </sch:pattern>

</sch:schema>