<!--
  ~ Copyright (c) 1999-2022. Allette Systems Pty Ltd
-->
<xsl:stylesheet version="2.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

  <xsl:param name="root-document-type" />
  <xsl:param name="format" /><!-- requires format param in publishing -->

  <!-- add document label for publication root document type -->
  <xsl:template match="uri[@documenttype=$root-document-type]">
    <xsl:copy>
      <xsl:copy-of select="@*"/>
      <xsl:apply-templates select="*[not(name()='labels')]"/>
      <labels>
        <xsl:value-of select="$root-document-type"/>
        <xsl:if test="normalize-space(labels) != ''">
          <xsl:value-of select="concat(',',labels)" />
        </xsl:if>
      </labels>
    </xsl:copy>
  </xsl:template>

  <!-- only output alternate documents for footnotes, endnotes and source -->
  <xsl:template match="(xref|blockxref)[@type='alternate' and
                       not(@documenttype = ('footnotes','endnotes','source'))]">
    <xsl:copy>
      <xsl:apply-templates select="@*"/>
      <xsl:value-of select="if (@display='manual') then @title else @urititle" />
    </xsl:copy>
  </xsl:template>

  <!-- add fragment type as a fragment label - ->
  <xsl:template match="fragment[@type]">
    <xsl:copy>
      <xsl:copy-of select="@*[not(name()='labels')]"/>
      <xsl:attribute name="labels">
        <xsl:value-of select="translate(@type,'.','_')"/>
        <xsl:if test="normalize-space(@labels) != ''">
          <xsl:value-of select="concat(',',@labels)" />
        </xsl:if>
      </xsl:attribute>
      <xsl:apply-templates />
    </xsl:copy>
  </xsl:template> -->

  <!-- convert properties to table when xref-fragment has label 'table' - ->
  <xsl:template match="xref-fragment[tokenize(@labels,',')='table']">
    <fragment id="{@id}">
      <table role="properties-table">
        <row part="header">
          <xsl:for-each select="(.//properties-fragment)[1]/property">
            <cell><xsl:value-of select="if (@title) then @title else @name" /></cell>
          </xsl:for-each>
        </row>
        <xsl:for-each select=".//properties-fragment">
          <row>
            <xsl:for-each select="property">
              <cell>
                <xsl:choose>
                  <xsl:when test="value">
                    <list>
                      <xsl:for-each select="value">
                        <item><xsl:value-of select="." /></item>
                      </xsl:for-each>
                    </list>
                  </xsl:when>
                  <xsl:otherwise>
                    <xsl:value-of select="@value" />
                  </xsl:otherwise>
                </xsl:choose>
              </cell>
            </xsl:for-each>
          </row>
        </xsl:for-each>
      </table>
    </fragment>
  </xsl:template> -->

  <!-- copy all other elements unchanged -->
  <xsl:template match="@*|node()">
    <xsl:copy>
      <xsl:apply-templates select="@*|node()"/>
    </xsl:copy>
  </xsl:template>

</xsl:stylesheet>