<!--
  Generate request documents to set missing docids

  ~ Copyright (c) 1999-2025. Allette Systems Pty Ltd
  -->
<xsl:stylesheet version="2.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
  
  <xsl:output method="text" />
  
  <xsl:param name="member"/>
  <xsl:param name="group"/>
  <xsl:param name="folder"/>

  <xsl:variable name="project" select="substring-before($group, '-')" />
  
  <xsl:template match="/">
    <xsl:apply-templates select="//uri[not(@docid) and ends-with(@path,'.psml')]"/>
  </xsl:template>
  
  <xsl:template match="uri">
    <xsl:result-document method="xml"
                         href="{concat('file:///',replace($folder,'\\','/'),'/request',@id,'.xml')}">
      <request path="/api/members/{$member}/groups/{$group}/uris/{@id}">
        <parameter name="documentid"><xsl:value-of select="$project" />-<xsl:value-of select="@id" /></parameter>
      </request>
    </xsl:result-document>
    <xsl:text>Generated docid </xsl:text><xsl:value-of select="$project" />-<xsl:value-of select="@id" /> for <xsl:value-of select="@path" /><xsl:text>
</xsl:text>
  </xsl:template>
</xsl:stylesheet>