<?xml version="1.0"?>
<!--
  Copy a publication

  ~ Copyright (c) 1999-2025. Allette Systems Pty Ltd
  -->
<xsl:stylesheet version="2.0"
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

  <xsl:param name="rooturiid" />
  <xsl:param name="newpubid" />
  <xsl:param name="newtitle" />

  <!-- modify root uri title and remove docid -->
  <xsl:template match="uri[ancestor::document/@id=$rooturiid]">
    <xsl:copy>
      <xsl:copy-of select="@*[not(name()='title' or name()='docid')]"/>
      <xsl:attribute name="title" select="$newtitle"></xsl:attribute>
      <xsl:apply-templates />
    </xsl:copy>
  </xsl:template>

  <!-- remove non-root uri docid -->
  <xsl:template match="uri[ancestor::document/@id!=$rooturiid]">
    <xsl:copy>
      <xsl:copy-of select="@*[not(name()='docid')]"/>
      <xsl:apply-templates />
    </xsl:copy>
  </xsl:template>

  <!-- modify root uri title heading -->
  <xsl:template match="heading[not(preceding::heading) and ancestor::document/@id=$rooturiid]">
    <xsl:copy>
      <xsl:copy-of select="@*[not(name()='title')]"/>
      <xsl:value-of select="$newtitle" />
    </xsl:copy>
  </xsl:template>

  <!-- modify root publication ID -->
  <xsl:template match="publication[ancestor::document/@id=$rooturiid]">
    <xsl:copy>
      <xsl:copy-of select="@*[not(name()='id')]"/>
      <xsl:attribute name="id" select="$newpubid"></xsl:attribute>
      <xsl:apply-templates />
    </xsl:copy>
  </xsl:template>

  <!-- remove non-root publications -->
  <xsl:template match="publication[ancestor::document/@id!=$rooturiid]" />

  <!-- for safety only add docid or uriid if not in publication folder -->
  <xsl:template match="xref|blockxref">
    <xsl:copy>
      <xsl:copy-of select="@*[name() != 'uriid' and name() != 'docid' and name() != 'href']" />
      <xsl:choose>
        <xsl:when test="@href and not(contains(@href,'_local/') or contains(@href,'_external/'))">
          <xsl:attribute name="href" select="@href" />
        </xsl:when>
        <xsl:when test="@docid">
          <xsl:attribute name="docid" select="@docid" />
        </xsl:when>
        <xsl:when test="@uriid">
          <xsl:attribute name="uriid" select="@uriid" />
        </xsl:when>
      </xsl:choose>
      <xsl:apply-templates select="node()" />
    </xsl:copy>
  </xsl:template>

  <!-- for safety only add docid or uriid if not in publication folder -->
  <xsl:template match="image">
    <xsl:copy>
      <xsl:copy-of select="@*[name() != 'uriid' and name() != 'docid' and name() != 'src']" />
      <xsl:choose>
        <xsl:when test="@src and not(contains(@src,'_local/') or contains(@src,'_external/'))">
          <xsl:attribute name="src" select="@src" />
        </xsl:when>
        <xsl:when test="@docid">
          <xsl:attribute name="docid" select="@docid" />
        </xsl:when>
        <xsl:when test="@uriid">
          <xsl:attribute name="uriid" select="@uriid" />
        </xsl:when>
      </xsl:choose>
      <xsl:apply-templates select="node()" />
    </xsl:copy>
</xsl:template>

<!-- create original-docid property for variation
<xsl:template match="metadata">
<xsl:copy>
<xsl:copy-of select="@*" />
<properties>
  <xsl:apply-templates select="properties/property" />
  <xsl:if test="/document/documentinfo/uri/@docid and not(properties/property[@name='original-docid'])">
    <property name="original-docid" title="Document ID of original"
              value="{/document/documentinfo/uri/@docid}"/>
  </xsl:if>
</properties>
</xsl:copy>
</xsl:template> -->

  <!-- copy all other elements unchanged -->
  <xsl:template match="@*|node()">
    <xsl:copy>
      <xsl:apply-templates select="@*|node()"/>
    </xsl:copy>
  </xsl:template>

</xsl:stylesheet>

