<?xml version="1.0"?>
<!--
  This schematron identifies documents that are using old versions of PSML which are no longer supported.

  @version 6.0000
-->
<sch:schema xmlns:sch="http://purl.oclc.org/dsdl/schematron" queryBinding="xslt2">

  <sch:title>Old PSML</sch:title>

  <!--
    Set of rules applying to the document fragments
  -->
  <sch:pattern name="Fragments">

    <!-- Rule matching regular fragments -->
    <sch:rule context="fragment">

      <!-- Tables must not use the 'align' attribute -->
      <sch:assert id="table_align" test="not(.//table/@align)" flag="error"
                  properties="fragment">
        Fragment '<sch:value-of select="@id"/>' has a table with 'align' set (remove the align attribute).
      </sch:assert>

      <!-- Links must not use the 'name' attribute -->
      <sch:assert id="link_name" test="not(.//link/@name)" flag="error"
                  properties="fragment">
        Fragment '<sch:value-of select="@id"/>' has a link with a 'name' attribute (use &lt;anchor name=""/&gt; instead).
      </sch:assert>

      <!-- Links must not contain 'image', 'link' or 'xref' elements -->
      <sch:assert id="link_content" test="not(.//link//image|.//link//link|.//link//xref)" flag="error"
                  properties="fragment">
        Fragment '<sch:value-of select="@id"/>' has a link containing an 'image', 'link' or 'xref' element (remove these).
      </sch:assert>

      <!-- Links must have an 'href' attribute -->
      <sch:assert id="link_no_href" test="not(.//link[not(@href)])" flag="error"
                  properties="fragment">
        Fragment '<sch:value-of select="@id"/>' has a link without an 'href' attribute (add an href attribute).
      </sch:assert>

      <!-- Para must not use the indent="0" attribute -->
      <sch:assert id="para_indent_zero" test="not(.//para[@indent='0'])" flag="error"
                  properties="fragment">
        Fragment '<sch:value-of select="@id"/>' has a para with indent="0" (remove the indent="0").
      </sch:assert>

      <!-- Para must not have both 'prefix' and numbered="true" attributes -->
      <sch:assert id="para_prefix_and_numbered" test="not(.//para[@prefix and @numbered='true'])" flag="error"
                  properties="fragment">
        Fragment '<sch:value-of select="@id"/>' has a para with 'prefix' and numbered="true" attributes (remove one of them).
      </sch:assert>

      <!-- Heading must not have both 'prefix' and numbered="true" attributes -->
      <sch:assert id="heading_prefix_and_numbered" test="not(.//heading[@prefix and @numbered='true'])" flag="error"
                  properties="fragment">
        Fragment '<sch:value-of select="@id"/>' has a heading with 'prefix' and numbered="true" attributes (remove one of them).
      </sch:assert>

      <!-- Heading must have a level attribute -->
      <sch:assert id="heading_no_level" test="not(.//heading[not(@level)])" flag="error"
                  properties="fragment">
        Fragment '<sch:value-of select="@id"/>' has a heading without a 'level' attribute (specify the heading level).
      </sch:assert>

    </sch:rule>

    <!-- Tables -->
    <sch:rule context="table">

      <!-- The <col> elements must match the number of columns in the table -->
      <sch:assert id="table_invalid_col_count" test="not(col) or count(col[not(@span)]) + sum(col/@span) = count(row[1]/*[not(@colspan)]) + sum(row[1]/*/@colspan)"
                  properties="fragment">
        Fragment '<sch:value-of select="ancestor::fragment/@id"/>' has &lt;col&gt; elements that don't match the number of columns in the table.
      </sch:assert>

    </sch:rule>

    <!-- Properties Fragment -->
    <sch:rule context="properties-fragment/property | properties/property">

      <!--
        Single value
       -->
      <sch:assert id="property_ambiguous_value" test="not(@value and value)" flag="error"
                  properties="fragment">The property element "<sch:value-of select="@name" />" can only have a value attribute or value elements (not both).</sch:assert>

      <!--
        Normal property cannot have xref or markdown element
       -->
      <sch:assert id="property_invalid_xref_md" test="not(not(@datatype='xref') and not(@datatype='markdown') and (xref or markdown))" flag="error"
                  properties="fragment">
        The property element "<sch:value-of select="@name" />" cannot have an xref or markdown element (use value attribute or elements).
      </sch:assert>

      <!--
        XRef property cannot have value
       -->
      <sch:assert id="xref_property_invalid" test="not(@datatype='xref' and (@value or value or markdown))" flag="error"
                  properties="fragment">
        The property element "<sch:value-of select="@name" />" cannot have a value attribute or value or markdown elements (use xref element).
      </sch:assert>

      <!--
        Markdown property cannot have value
       -->
      <sch:assert id="md_property_invalid" test="not(@datatype='markdown' and (@value or value or xref))" flag="error"
                  properties="fragment">
        The property element "<sch:value-of select="@name" />" cannot have a value attribute or value or xref elements (use markdown element).
      </sch:assert>

      <!--
        Count attribute is deprecated
       -->
      <sch:assert id="property_count" test="not(@count)" properties="fragment">
        The property element "<sch:value-of select="@name" />" has a count attribute which is deprecated (use multiple="true" attribute if required).
      </sch:assert>

    </sch:rule>

  </sch:pattern>

  <sch:properties>

    <sch:property id="fragment"><sch:value-of select="ancestor-or-self::fragment/@id"/></sch:property>

  </sch:properties>

</sch:schema>
