<!--
  ~ Copyright (c) 1999-2019 Allette Systems Pty Ltd
  -->
<xsl:stylesheet version="3.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:json="http://www.w3.org/2005/xpath-functions"
                xmlns:f="http://www.pageseeder.com/function"
                exclude-result-prefixes="#all">

<xsl:template match="root[@service='api-document']|root[@service='api-document-path']" mode="json">
  <json:map>
    <xsl:apply-templates select="content/document" mode="json-document">
      <xsl:with-param name="key" select="'document'"/>
    </xsl:apply-templates>
    <xsl:apply-templates select="content/document-type|content/document-extension|content/url-type" mode="api-document-json"/>
  </json:map>
</xsl:template>

<!-- When underlying document does not exist -->
<xsl:template match="root[@service='api-document' and content/@status='not-found']" mode="json" priority="2">
  <json:map>
    <json:map key="document">
      <xsl:if test="@id"><json:number key="id"><xsl:value-of select="@id"/></json:number></xsl:if>
      <json:string key="schemaversion"><xsl:value-of select="@schemaversion"/></json:string>
      <json:string key="status"><xsl:value-of select="@status"/></json:string>
      <json:string key="version"><xsl:value-of select="@version"/></json:string>
      <json:string key="level"><xsl:value-of select="@level"/></json:string>
      <json:boolean key="lockstructure"><xsl:value-of select="@lockstructure = 'true'"/></json:boolean>
      <json:boolean key="readonly"><xsl:value-of select="@edit = 'false'"/></json:boolean>
      <json:boolean key="hasNumbering">false</json:boolean>
      <json:boolean key="isBroken">false</json:boolean>
      <json:string key="publicationid"><xsl:value-of select="@publicationid"/></json:string>
      <json:string key="type"><xsl:value-of select="@type"/></json:string>
      <xsl:if test="@position">
        <json:number key="position"><xsl:value-of select="@position"/></json:number>
      </xsl:if>
      <xsl:if test="@date">
        <json:string key="date"><xsl:value-of select="@date"/></json:string>
      </xsl:if>
      <xsl:variable name="uri" select="(//uri[sharing][@id = current()/@id])[1]" />
      <xsl:apply-templates select="if ($uri) then ($uri) else documentinfo/uri" mode="json">
        <xsl:with-param name="key" select="'uri'"/>
      </xsl:apply-templates>
      <json:array key="versions"/>
      <json:array key="reversexrefs"/>
      <json:array key="locators"/>
      <json:array key="xrefs"/>
      <json:array key="links"/>
      <json:array key="images"/>
      <json:array key="structure"/>
      <json:array key="fragments" />
    </json:map>
    <xsl:apply-templates select="content/document-type|content/document-extension|content/url-type" mode="api-document-json"/>
  </json:map>
</xsl:template>

<xsl:template match="root[@service='api-document-config']" mode="json">
  <json:map>
    <xsl:apply-templates select="content/document-type|content/document-extension" mode="api-document-json"/>
  </json:map>
</xsl:template>

<xsl:template match="root[@service='api-url-config']" mode="json">
  <json:map>
    <xsl:apply-templates select="content/url-type" mode="api-document-json"/>
  </json:map>
</xsl:template>

<!--
  PSML documents
-->
<xsl:template match="document-type" mode="api-document-json">
  <json:string key="icon"><xsl:value-of select="$site-prefix" /><xsl:value-of select="@icon" /></json:string>
  <xsl:if test="@css and not(ends-with(@css, 'psml-content.css'))">
    <json:string key="css"><xsl:value-of select="$site-prefix" /><xsl:value-of select="@css" /></json:string>
  </xsl:if>
  <xsl:apply-templates select="document-config"   mode="json-config">
    <xsl:with-param name="key" select="'config'"/>
  </xsl:apply-templates>
  <xsl:apply-templates select="document-template" mode="json-config">
    <xsl:with-param name="key" select="'template'"/>
  </xsl:apply-templates>
  <xsl:apply-templates select="editor-configs"    mode="json-config">
    <xsl:with-param name="key" select="'editorConfigs'"/>
  </xsl:apply-templates>
  <xsl:if test="help">
    <json:map key="help">
      <json:string key="format"><xsl:value-of select="help/@type" /></json:string>
      <json:string key="content"><xsl:value-of select="help" /></json:string>
    </json:map>
  </xsl:if>
</xsl:template>

<!--
  non-PSML documents
-->
<xsl:template match="document-extension" mode="api-document-json">
  <json:map key="config">
    <xsl:apply-templates select="label-config" mode="json-config" />
  </json:map>
  <xsl:apply-templates select="media-template" mode="json-config">
    <xsl:with-param name="key" select="'template'"/>
  </xsl:apply-templates>
  <xsl:apply-templates select="editor-configs"    mode="json-config">
    <xsl:with-param name="key" select="'editorConfigs'"/>
  </xsl:apply-templates>
  <xsl:if test="help">
    <json:map key="help">
      <json:string key="format"><xsl:value-of select="help/@type" /></json:string>
      <json:string key="content"><xsl:value-of select="help" /></json:string>
    </json:map>
  </xsl:if>
</xsl:template>

<!--
  URLs
-->
<xsl:template match="url-type" mode="api-document-json">
  <xsl:apply-templates select="url-config" mode="json-config">
    <xsl:with-param name="key" select="'config'"/>
  </xsl:apply-templates>
  <xsl:apply-templates select="url-template" mode="json-config">
    <xsl:with-param name="key" select="'template'"/>
  </xsl:apply-templates>
  <xsl:apply-templates select="editor-configs" mode="json-config">
    <xsl:with-param name="key" select="'editorConfigs'"/>
  </xsl:apply-templates>
  <xsl:if test="help">
    <json:map key="help">
      <json:string key="format"><xsl:value-of select="help/@type" /></json:string>
      <json:string key="content"><xsl:value-of select="help" /></json:string>
    </json:map>
  </xsl:if>
</xsl:template>

</xsl:stylesheet>
