<!--
  ~ Copyright (c) 1999-2021. Allette Systems Pty Ltd
  -->
<xsl:stylesheet version="3.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:json="http://www.w3.org/2005/xpath-functions"
                xmlns:diff="https://www.pageseeder.org/diffx"
                xmlns:track="https://www.pageseeder.org/diffx/track"
                exclude-result-prefixes="#all">

<xsl:template match="root[@service='api-document-tracker']" mode="json">
  <xsl:variable name="doc">
    <xsl:for-each select="content/document">
      <document tracker="true">
        <xsl:copy-of select="@*"/>
        <documentinfo>
          <xsl:copy-of select="documentinfo/uri|documentinfo/reversexrefs"/>
        </documentinfo>
        <xsl:apply-templates select="metadata|toc|section" mode="tracker-combined"/>
        <!-- For use by diff elements -->
        <xsl:copy-of select="descendant::edits/edit"/>
      </document>
    </xsl:for-each>
  </xsl:variable>
  <json:map>
    <xsl:apply-templates select="$doc" mode="json-document">
      <xsl:with-param name="key" select="'document'"/>
    </xsl:apply-templates>
    <json:map key="stats">
      <!-- TODO compute stats per author -->
      <!--      <json:number key="charsTotal">-->
      <!--        <xsl:variable name="content"><xsl:value-of select="//section/*"/></xsl:variable>-->
      <!--        <xsl:value-of select="string-length(normalize-space($content))"/>-->
      <!--      </json:number>-->
      <!--      <json:array>-->
      <!--        <xsl:for-each select=""-->
      <!--      </json:array>-->
      <!--      -->
      <!--      <json:number key="charsInserted">-->
      <!--        <xsl:variable name="ins"><xsl:value-of select="$content-locators//diff:ins"/></xsl:variable>-->
      <!--        <xsl:value-of select="string-length(normalize-space($ins))"/>-->
      <!--      </json:number>-->
      <!--      <json:number key="charsDeleted">-->
      <!--        <xsl:variable name="del"><xsl:value-of select="$content-locators//diff:del"/></xsl:variable>-->
      <!--        <xsl:value-of select="string-length(normalize-space($del))"/>-->
      <!--      </json:number>-->
    </json:map>
    <json:array key="edits">
      <!-- Can be `draft` or `edit` -->
      <xsl:for-each select="content/document//edits/edit">
        <json:map>
          <json:number key="id"><xsl:value-of select="@id" /></json:number>
          <json:string key="created"><xsl:value-of select="@created" /></json:string>
          <xsl:apply-templates select="author" mode="json" />
          <xsl:if test="notes/note">
            <json:array key="notes">
              <xsl:apply-templates select="notes/note" mode="json-document" />
            </json:array>
          </xsl:if>
        </json:map>
      </xsl:for-each>
    </json:array>
  </json:map>
</xsl:template>

<!-- Remove @diff:insert and @diff:delete -->
<xsl:template match="*" mode="tracker-combined">
<xsl:copy>
  <xsl:copy-of select="@* except (@diff:insert|@diff:delete)"/>
  <xsl:apply-templates mode="#current"/>
</xsl:copy>
</xsl:template>

<!-- Remove @diff:insert, @diff:delete and inject @labels in fragments -->
<xsl:template match="fragment|media-fragment|properties-fragment|xref-fragment" mode="tracker-combined">
  <xsl:copy>
    <xsl:attribute name="labels"><xsl:value-of select="//locator[@fragment = current()/@id]/labels"/></xsl:attribute>
    <xsl:copy-of select="@* except (@diff:insert|@diff:delete|@labels)"/>
    <xsl:apply-templates mode="#current"/>
  </xsl:copy>
</xsl:template>

<!-- Replace the `ins` by `span` (easier to transform into `mark`) and remove @diff:insert and @diff:delete -->
<xsl:template match="track:ins" mode="tracker-combined">
<track:span>
  <xsl:copy-of select="@* except (@diff:insert|@diff:delete)"/>
  <xsl:apply-templates mode="#current"/>
</track:span>
</xsl:template>

<!-- Replace the `ins` by `span` (easier to transform into `mark`) and remove @diff:insert and @diff:delete -->
<xsl:template match="blockxref[string(@urititle) = '' and @type = 'transclude']" mode="tracker-combined">
  <xsl:copy>
    <xsl:copy-of select="@* except (@diff:insert|@diff:delete|@urititle)"/>
    <xsl:attribute name="urititle"><xsl:apply-templates mode="track-xref-urititle" /></xsl:attribute>
    <xsl:apply-templates mode="#current"/>
  </xsl:copy>
</xsl:template>
<!-- ignore deleted parts of the xref content to load the uri title -->
<xsl:template match="track:del" mode="track-xref-urititle" />

</xsl:stylesheet>