<!--
  ~ Copyright (c) 1999-2019 Allette Systems Pty Ltd
-->
<xsl:stylesheet version="3.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:json="http://www.w3.org/2005/xpath-functions"
                xmlns:track="https://www.pageseeder.org/diffx/track"
                xmlns:del="https://www.pageseeder.org/diffx/delete"
                xmlns:ins="https://www.pageseeder.org/diffx/insert"
                exclude-result-prefixes="#all">

<xsl:template match="root[@service='api-document-fragment-compare']" mode="json">
  <json:array>
    <xsl:variable name="edits" select="content/edits/*" />
    <!-- Can be `draft` or `edit` -->
    <xsl:for-each select="$edits">
      <json:map>
        <json:number key="id"><xsl:value-of select="@id" /></json:number>
        <json:string key="created"><xsl:value-of select="@created" /></json:string>
        <xsl:apply-templates select="author" mode="json" />
        <xsl:apply-templates select="acceptedby" mode="json">
          <xsl:with-param name="key" select="'acceptedby'"/>
        </xsl:apply-templates>
        <xsl:apply-templates select="draftauthor" mode="json">
          <xsl:with-param name="key" select="'draftauthor'"/>
        </xsl:apply-templates>
        <xsl:if test="@skipped"><json:number key="skipped"><xsl:value-of select="@skipped" /></json:number></xsl:if>
        <xsl:if test="@deleted = 'true'"><json:boolean key="deleted">true</json:boolean></xsl:if>
        <xsl:if test="self::draft">
          <json:boolean key="draft">true</json:boolean>
          <json:string key="content"><xsl:value-of select="serialize(content/*)" /></json:string>
        </xsl:if>
        <xsl:choose>
          <xsl:when test="@original = 'true'">
            <json:boolean key="original">true</json:boolean>
            <xsl:variable name="html"><xsl:apply-templates select="content/*" mode="psml" /></xsl:variable>
            <json:string key="diff"><xsl:value-of select="serialize($html)" /></json:string>
          </xsl:when>
          <xsl:when test="empty(diff)">
            <json:boolean key="inserted">true</json:boolean>
            <xsl:variable name="html">
              <xsl:apply-templates select="content/*" mode="psml">
                <xsl:with-param name="inserted" select="true()" tunnel="yes" />
              </xsl:apply-templates>
            </xsl:variable>
            <json:string key="diff"><xsl:value-of select="serialize($html)" /></json:string>
          </xsl:when>
          <xsl:when test="diff/@error">
            <json:string key="error"><xsl:value-of select="diff/@error" /></json:string>
          </xsl:when>
          <!-- don't use diff for mathml -->
          <xsl:when test="diff/media-fragment/@mediatype = 'application/mathml+xml'">
            <xsl:variable name="html">
              <xsl:apply-templates select="content/*" mode="mathml-ins"/>
              <xsl:apply-templates select="preceding-sibling::edit[1]/content/*" mode="mathml-del"/>
            </xsl:variable>
            <json:string key="diff"><xsl:value-of select="serialize($html)" /></json:string>
          </xsl:when>
          <xsl:otherwise>
            <xsl:variable name="html"><xsl:apply-templates select="diff/*" mode="psml" /></xsl:variable>
            <json:string key="diff"><xsl:value-of select="serialize($html)" /></json:string>
          </xsl:otherwise>
        </xsl:choose>

        <xsl:variable name="old-labels" select="tokenize(diff/*/@del:labels, ',')" />
        <xsl:variable name="labels" select="tokenize(diff/*/@labels, ',')" />
        <xsl:variable name="labels-are-new" select="diff/*/@ins:labels = 'true'" />
        <json:array key="labels">
          <xsl:for-each select="$labels"><json:string><xsl:sequence select="." /></json:string></xsl:for-each>
        </json:array>
        <json:array key="diffLabels">
          <!-- No diff? This was ported from old code not sure when it is necessary -->
          <xsl:if test="empty(diff) and string(content/*/@labels) != ''">
            <xsl:for-each select="tokenize(content/*/@labels, ',')">
              <json:map>
                <json:string key="name"><xsl:sequence select="." /></json:string>
                <json:boolean key="ins">true</json:boolean>
              </json:map>
            </xsl:for-each>
          </xsl:if>
          <!-- When diff -->
          <xsl:for-each select="$labels">
            <json:map>
              <json:string key="name"><xsl:sequence select="." /></json:string>
              <xsl:if test="empty($old-labels[. = current()]) and $labels-are-new">
                <json:boolean key="ins">true</json:boolean>
              </xsl:if>
            </json:map>
          </xsl:for-each>
          <xsl:for-each select="$old-labels[not(.=$labels)]">
            <json:map>
              <json:string key="name"><xsl:sequence select="." /></json:string>
              <json:boolean key="del">true</json:boolean>
            </json:map>
          </xsl:for-each>
        </json:array>
        <xsl:if test="notes/note">
          <json:array key="notes">
            <xsl:apply-templates select="notes/note" mode="json-document" />
          </json:array>
        </xsl:if>
      </json:map>
    </xsl:for-each>
  </json:array>
</xsl:template>


<xsl:template match="text()" mode="psml">
  <xsl:param name="inserted" select="false()" tunnel="yes" />
  <xsl:choose>
    <xsl:when test="$inserted = true()"><ins><xsl:value-of select="." /></ins></xsl:when>
    <xsl:otherwise><xsl:value-of select="." /></xsl:otherwise>
  </xsl:choose>
</xsl:template>

</xsl:stylesheet>
