<!--
  ~ Copyright (c) 1999-2019 Allette Systems Pty Ltd
  -->
<xsl:stylesheet version="3.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:json="http://www.w3.org/2005/xpath-functions"
                exclude-result-prefixes="#all">

<xsl:template match="root[@service='api-admin-templates']" mode="json">
<json:map>
  <json:array key="templates">
    <xsl:for-each select="content/projects/project">
      <json:map>
        <json:number key="id"><xsl:value-of select="@id"/></json:number>
        <json:string key="name"><xsl:value-of select="@name"/></json:string>
        <json:string key="title"><xsl:value-of select="@title"/></json:string>
        <json:string key="description"><xsl:value-of select="@description"/></json:string>
        <json:string key="owner"><xsl:value-of select="@owner"/></json:string>
        <json:string key="access"><xsl:value-of select="@access"/></json:string>
        <json:boolean key="common"><xsl:value-of select="@common = 'true'"/></json:boolean>
      </json:map>
    </xsl:for-each>
  </json:array>
</json:map>
</xsl:template>


</xsl:stylesheet>
