<!--
  ~ Copyright (c) 1999-2019 Allette Systems Pty Ltd
  -->
<xsl:stylesheet version="3.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:json="http://www.w3.org/2005/xpath-functions"
                exclude-result-prefixes="#all">

<xsl:template match="root[@service='api-admin-statistics']" mode="json">
<json:map>
  <json:array key="statistics">
    <xsl:for-each select="//statistic">
      <json:map>
        <json:string key="generator"><xsl:value-of select="@generator"/></json:string>
        <json:number key="count"><xsl:value-of select="@count"/></json:number>
        <json:number key="minProcess"><xsl:value-of select="@min-process"/></json:number>
        <json:number key="maxProcess"><xsl:value-of select="@max-process"/></json:number>
        <json:number key="totalProcess"><xsl:value-of select="@total-process"/></json:number>
        <json:number key="avgProcess"><xsl:value-of select="@avg-process"/></json:number>
        <json:number key="avgLastProcess"><xsl:value-of select="@avg-last-process"/></json:number>
        <json:array key="recent">
          <xsl:for-each select="tokenize(@recent, ',')">
            <json:number><xsl:value-of select="."/></json:number>
          </xsl:for-each>
        </json:array>
        <json:map key="status">
          <xsl:for-each select="status/@*">
            <json:number key="{name()}"><xsl:value-of select="."/></json:number>
          </xsl:for-each>
        </json:map>
      </json:map>
    </xsl:for-each>
  </json:array>
</json:map>
</xsl:template>

</xsl:stylesheet>
