<!--
  ~ Copyright (c) 1999-2018 Allette Systems Pty Ltd
  -->
<xsl:stylesheet version="3.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:json="http://www.w3.org/2005/xpath-functions"
                exclude-result-prefixes="#all">

<xsl:template match="root[@service='api-admin-message']" mode="json">
  <xsl:variable name="server-message" select="(//server-message)[1]"/>
  <json:map>
    <xsl:choose>
      <xsl:when test="$server-message">
        <json:string key="text"><xsl:value-of select="$server-message"/></json:string>
        <json:string key="md5"><xsl:value-of select="$server-message/@md5"/></json:string>
      </xsl:when>
      <xsl:otherwise>
        <json:null key="text"/>
        <json:null key="md5"/>
      </xsl:otherwise>
    </xsl:choose>
  </json:map>
</xsl:template>

</xsl:stylesheet>
