<!--
  ~ Copyright (c) 1999-2018 Allette Systems Pty Ltd
  -->
<xsl:stylesheet version="3.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:json="http://www.w3.org/2005/xpath-functions"
                xmlns:f="http://www.pageseeder.com/function"
                exclude-result-prefixes="#all">

<!-- Access logs -->
<xsl:template match="root[@service='api-admin-logs-access' or @service='api-admin-logs-access-tickets']" mode="json">
  <json:map>
    <json:array key="tickets">
      <xsl:choose>
        <xsl:when test="content/summary/group">
          <xsl:apply-templates select="content/summary/group" mode="api-admin-logs"/>
        </xsl:when>
        <xsl:otherwise>
          <xsl:apply-templates select="content/summary//ticket" mode="json"/>
        </xsl:otherwise>
      </xsl:choose>
    </json:array>
  </json:map>
</xsl:template>

<!-- General logs -->
<xsl:template match="root[@service='api-admin-logs-general' or
                          @service='api-admin-logs-general-track']" mode="json">
  <json:map>
    <xsl:for-each select="//events">
      <json:string key="date"><xsl:value-of select="@date | @target"/></json:string>
      <xsl:if test="@page"><json:string key="page"><xsl:value-of select="@page"/></json:string></xsl:if>
      <xsl:if test="@more"><json:boolean key="more"><xsl:value-of select="@more = 'true'"/></json:boolean></xsl:if>
      <json:array key="events">
        <xsl:apply-templates select="event" mode="json-simple">
          <xsl:sort select="@datetime" order="ascending"/>
          <!-- datetime is not as precise as timestamp so rely on position
               for events in same time, and order is ascending by default -->
          <xsl:sort select="position()" order="ascending"/>
        </xsl:apply-templates>
      </json:array>
    </xsl:for-each>
  </json:map>
</xsl:template>

<!-- Recent logs -->
<xsl:template match="root[@service='api-admin-logs-recent']" mode="json">
  <json:map>
    <xsl:for-each select="//events">
      <json:string key="datetime"><xsl:value-of select="@datetime"/></json:string>
      <xsl:if test="@more"><json:boolean key="more"><xsl:value-of select="@more = 'true'"/></json:boolean></xsl:if>
      <json:array key="events">
        <xsl:apply-templates select="event" mode="json-simple">
          <xsl:sort select="@timestamp" data-type="number" order="descending"/>
          <!-- for events in same millisecond, rely on position and order is descending for recent logs -->
          <xsl:sort select="position()" order="descending" />
        </xsl:apply-templates>
      </json:array>
    </xsl:for-each>
  </json:map>
</xsl:template>

<!-- Index/Process/Publish logs -->
<xsl:template match="root[@service='api-admin-logs-process' or
                          @service='api-group-admin-logs-process' or
                          @service='api-group-admin-logs-process-tickets' or
                          @service='api-admin-logs-process-tickets' or
                          @service='api-admin-logs-index' or
                          @service='api-group-admin-logs-index' or
                          @service='api-group-admin-logs-index-tickets' or
                          @service='api-admin-logs-index-tickets' or
                          @service='api-admin-logs-publish' or
                          @service='api-project-admin-logs-publish' or
                          @service='api-group-admin-logs-publish' or
                          @service='api-project-admin-logs-publish-tickets' or
                          @service='api-group-admin-logs-publish-tickets' or
                          @service='api-admin-logs-publish-tickets']" mode="json">
  <json:map>
    <json:string key="date"><xsl:value-of select="//summary/@date"/></json:string>
    <json:array key="groups">
      <xsl:apply-templates select="//summary/group" mode="api-admin-logs" />
    </json:array>
  </json:map>
</xsl:template>

<xsl:template match="group" mode="api-admin-logs">
  <json:map>
    <json:string key="name"><xsl:value-of select="if (@name) then @name else '~'"/></json:string>
    <xsl:if test="@id"><json:number key="id"><xsl:value-of select="@id"/></json:number></xsl:if>
    <json:number key="infos"><xsl:value-of select="if (//root[@service='api-admin-logs-index' or @service='api-admin-logs-index-tickets']) then floor(sum(ticket/@infos) div 2) else sum(ticket/@infos)"/></json:number>
    <json:number key="warnings"><xsl:value-of select="sum(ticket/@warnings)"/></json:number>
    <json:number key="errors"><xsl:value-of select="sum(ticket/@errors)"/></json:number>
    <json:array key="tickets">
      <xsl:apply-templates select="ticket" mode="json">
        <xsl:with-param name="indexing" select="//root/@service = 'api-admin-logs-index' or //root/@service = 'api-admin-logs-index-tickets'"/>
      </xsl:apply-templates>
    </json:array>
  </json:map>
</xsl:template>

<xsl:template match="root[@service='api-admin-logs-index-summary' or
                          @service='api-group-admin-logs-index-summary' or
                          @service='api-admin-logs-mail-summary' or
                          @service='api-admin-logs-process-summary' or
                          @service='api-group-admin-logs-process-summary' or
                          @service='api-admin-logs-publish-summary' or
                          @service='api-group-admin-logs-publish-summary']" mode="json">
  <json:map>
    <xsl:for-each select="//summary">
      <json:map key="{@date}">
        <json:number key="infos"><xsl:value-of select="if (//root[contains(@service,'index')]) then floor(sum(descendant::ticket/@infos) div 2) else sum(descendant::ticket/@infos)"/></json:number>
        <json:number key="warnings"><xsl:value-of select="sum(descendant::ticket/@warnings)"/></json:number>
        <json:number key="errors"><xsl:value-of select="sum(descendant::ticket/@errors)"/></json:number>
      </json:map>
    </xsl:for-each>
  </json:map>
</xsl:template>

<!-- For general/recent logs only -->
<xsl:template match="event" mode="json-simple">
  <json:map>
    <!-- We convert from milli to micro to avoid duplicates -->
    <xsl:variable name="timestamp-micro" select="f:timestamp-micro(.)"/>
    <json:string key="datetime"><xsl:value-of select="@datetime"/></json:string>
    <json:string key="level"><xsl:value-of select="@level"/></json:string>
    <json:string key="logger"><xsl:value-of select="@logger"/></json:string>
    <json:string key="message"><xsl:value-of select="f:safe-message(@message|message)"/></json:string>
    <json:number key="timestamp"><xsl:value-of select="$timestamp-micro"/></json:number>
    <xsl:if test="@thread"><json:string key="thread"><xsl:value-of select="@thread"/></json:string></xsl:if>
    <xsl:if test="extra"><json:string key="extra"><xsl:value-of select="extra"/></json:string></xsl:if>
    <xsl:if test="throwable">
      <json:array key="throwables">
        <xsl:apply-templates select="throwable" mode="json" />
      </json:array>
    </xsl:if>
  </json:map>
</xsl:template>

</xsl:stylesheet>
