<!--
  ~ Copyright (c) 1999-2018 Allette Systems Pty Ltd
  -->
<xsl:stylesheet version="3.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:json="http://www.w3.org/2005/xpath-functions"
                xmlns:xs="http://www.w3.org/2001/XMLSchema"
                exclude-result-prefixes="#all">

<xsl:template match="root[@service='api-admin-logs-security']" mode="json">
  <json:map>
    <xsl:for-each select="//events">
      <json:string key="date"><xsl:value-of select="@date | @target"/></json:string>
      <xsl:if test="@page"><json:string key="page"><xsl:value-of select="@page"/></json:string></xsl:if>
      <xsl:if test="@more"><json:boolean key="more"><xsl:value-of select="@more = 'true'"/></json:boolean></xsl:if>
      <json:array key="events">
        <xsl:for-each select="event">
          <!-- TODO Timestamp ? -->
          <json:map>
            <json:string key="datetime"><xsl:value-of select="@datetime"/></json:string>
            <json:string key="level"><xsl:value-of select="@level"/></json:string>
            <json:string key="ip"><xsl:value-of select="@ip"/></json:string>
            <json:string key="method"><xsl:value-of select="@method"/></json:string>
            <json:string key="path"><xsl:value-of select="@path"/></json:string>
            <json:string key="type"><xsl:value-of select="@type"/></json:string>
            <json:number key="memberid"><xsl:value-of select="if (@member castable as xs:int) then @member else -1"/></json:number>
            <json:string key="username"><xsl:value-of select="@username"/></json:string>
            <json:string key="message"><xsl:value-of select="@message"/></json:string>
            <!-- User agent string -->
            <json:string key="userAgent"><xsl:value-of select="@user-agent"/></json:string>
            <json:string key="browser"><xsl:value-of select="@browser"/></json:string>
            <json:string key="browserType"><xsl:value-of select="@browser-type"/></json:string>
            <json:string key="browserVersion"><xsl:value-of select="@browser-version"/></json:string>
            <json:string key="deviceType"><xsl:value-of select="@device-type"/></json:string>
            <json:string key="platform"><xsl:value-of select="@platform"/></json:string>
            <json:string key="platformVersion"><xsl:value-of select="@platform-version"/></json:string>
          </json:map>
        </xsl:for-each>
      </json:array>
    </xsl:for-each>
  </json:map>
</xsl:template>

</xsl:stylesheet>
