<!--
  ~ Copyright (c) 1999-2018 Allette Systems Pty Ltd
  -->
<xsl:stylesheet version="3.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:f="http://www.pageseeder.com/function"
                xmlns:json="http://www.w3.org/2005/xpath-functions"
                exclude-result-prefixes="#all">

<xsl:template match="root[@service='api-admin-logs-publish-ticket' or
                          @service='api-project-admin-logs-publish-ticket' or
                          @service='api-group-admin-logs-publish-ticket']" mode="json">
  <xsl:variable name="ticket-id" select="//parameter[@name='ticket']"/>
  <xsl:variable name="ticket" select="//ticket[@id=$ticket-id]"/>
  <json:map>
    <xsl:apply-templates select="$ticket" mode="json">
      <xsl:with-param name="key">ticket</xsl:with-param>
    </xsl:apply-templates>
    <xsl:if test="not($ticket)">
      <json:null key="ticket"/>
    </xsl:if>
    <xsl:if test="content/events/@more = 'true'"><json:boolean key="more">true</json:boolean></xsl:if>
    <json:array key="events">
      <xsl:variable name="first-event" select="//event[1]"/>
      <xsl:apply-templates select="//event" mode="json">
        <xsl:with-param name="first-event" select="$first-event"/>
      </xsl:apply-templates>
    </json:array>
  </json:map>
</xsl:template>

<!--
  <publish type="info" uripath="/ps/ps/doc/user/website/content/home.psml" started="1531280426955" target="psml-to-website">
    <message>Exporting document /ps/ps/doc/user/website/content/home.psml to Website</message>
  </publish>
-->
<xsl:template match="event/publish" mode="json">
  <xsl:if test="message/threadid">
    <json:string key="threadid"><xsl:value-of select="message/threadid" /></json:string>
    <xsl:if test="message/threadid/@group">
      <json:string key="threadgroup"><xsl:value-of select="message/threadid/@group" /></json:string>
    </xsl:if>
  </xsl:if>
  <json:string key="message">
    <xsl:choose>
      <xsl:when test="message/threadid or message/parameters/parameter" />
      <xsl:when test="@type = 'start'">Start of publishing</xsl:when>
      <xsl:when test="message/displayUriPath">Display path: <xsl:sequence select="f:safe-message(message/displayUriPath)"/></xsl:when>
      <xsl:when test="message/previewPath">Preview path: <xsl:sequence select="f:safe-message(message/previewPath)"/></xsl:when>
      <xsl:when test="message/publisherPath">Publisher path: <xsl:sequence select="f:safe-message(message/publisherPath)"/></xsl:when>
      <xsl:when test="message/downloadLink">Download link: <xsl:sequence select="f:safe-message(message/downloadLink)"/></xsl:when>
      <xsl:when test="message/uriLink">Open link: <xsl:sequence select="f:safe-message(message/uriLink)"/></xsl:when>
      <xsl:when test="message/displayPanelPath">Panel path: <xsl:sequence select="f:safe-message(message/displayPanelPath)"/></xsl:when>
      <xsl:when test="message/reload">Reload document</xsl:when>
      <xsl:otherwise><xsl:sequence select="f:safe-message(serialize(message/node()))"/></xsl:otherwise>
    </xsl:choose>
  </json:string>
  <xsl:if test="message/script">
    <json:map key="script">
      <xsl:for-each select="message/script/@*">
        <json:string key="{name()}"><xsl:value-of select="." /></json:string>
      </xsl:for-each>
    </json:map>
  </xsl:if>
  <xsl:if test="message/parameters/parameter">
    <json:array key="parameters">
      <xsl:for-each select="message/parameters/parameter">
        <json:map>
          <json:string key="name" ><xsl:value-of select="@name" /></json:string>
          <json:string key="value"><xsl:value-of select="@value" /></json:string>
        </json:map>
      </xsl:for-each>
    </json:array>
  </xsl:if>
  <xsl:apply-templates select="throwable" mode="json">
    <xsl:with-param name="key">throwable</xsl:with-param>
  </xsl:apply-templates>
</xsl:template>


</xsl:stylesheet>
