<!--
  ~ Copyright (c) 1999-2022. Allette Systems Pty Ltd
  -->
<xsl:stylesheet version="3.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:json="http://www.w3.org/2005/xpath-functions"
                exclude-result-prefixes="#all">

<xsl:template match="root[@service='api-admin-logs-mail']" mode="json">
  <json:map>
    <json:boolean key="hasMore"><xsl:value-of select="//events/more = 'true'" /></json:boolean>
    <json:array key="events">
      <xsl:variable name="first-event" select="//event[1]"/>
      <xsl:apply-templates select="//event" mode="json">
        <xsl:with-param name="first-event" select="$first-event"/>
      </xsl:apply-templates>
    </json:array>
    <json:map key="bounces">
      <json:number key="count"><xsl:value-of select="if (//bounces/@total) then (//bounces/@total)[1] else 0" /></json:number>
      <json:array key="to">
        <xsl:for-each select="//bounces[@type = 'to']/bounce">
          <json:map>
            <json:string key="address"><xsl:value-of select="@address" /></json:string>
            <json:number key="count"><xsl:value-of select="if (@count) then @count else 0" /></json:number>
          </json:map>
        </xsl:for-each>
      </json:array>
      <json:array key="from">
        <xsl:for-each select="//bounces[@type = 'from']/bounce">
          <json:map>
            <json:string key="address"><xsl:value-of select="@address" /></json:string>
            <json:number key="count"><xsl:value-of select="if (@count) then @count else 0" /></json:number>
          </json:map>
        </xsl:for-each>
      </json:array>
    </json:map>
  </json:map>
</xsl:template>

</xsl:stylesheet>
