<!--
  ~ Copyright (c) 1999-2018 Allette Systems Pty Ltd
  -->
<xsl:stylesheet version="3.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:json="http://www.w3.org/2005/xpath-functions"
                exclude-result-prefixes="#all">

<xsl:template match="root[@service='api-admin-index-about']" mode="json">
  <xsl:variable name="about" select="content/about-index"/>
  <json:map>
    <json:map key="index">
      <json:string key="version"><xsl:value-of select="$about/index/@version"/></json:string>
    </json:map>
    <json:map key="groups">
      <json:number key="current"><xsl:value-of select="$about/groups/@current"/></json:number>
      <json:number key="old"><xsl:value-of select="$about/groups/@old"/></json:number>
      <json:number key="obsolete"><xsl:value-of select="$about/groups/@obsolete"/></json:number>
    </json:map>
    <xsl:if test="$about/personal-groups">
      <json:map key="personalGroups">
        <json:number key="current"><xsl:value-of select="$about/personal-groups/@current"/></json:number>
        <json:number key="old"><xsl:value-of select="$about/personal-groups/@old"/></json:number>
        <json:number key="obsolete"><xsl:value-of select="$about/personal-groups/@obsolete"/></json:number>
      </json:map>
    </xsl:if>
    <xsl:if test="$about/urls">
      <json:map key="urls">
        <json:string key="version"><xsl:value-of select="$about/urls/@version"/></json:string>
        <json:string key="status">
          <xsl:choose>
            <xsl:when test="$about/urls/@version = $about/index/@version">current</xsl:when>
            <xsl:when test="number($about/urls/@version) - number($about/index/@version) lt 1000">old</xsl:when>
            <xsl:otherwise>obsolete</xsl:otherwise>
          </xsl:choose>
        </json:string>
      </json:map>
    </xsl:if>
  </json:map>
</xsl:template>

<xsl:template match="root[@service='api-admin-index-status']" mode="json">
  <json:map>
    <xsl:variable name="jobs" select="//indexing/status/jobs"/>
    <json:number key="total"><xsl:value-of select="if ($jobs/@total) then $jobs/@total else 0"/></json:number>
    <json:number key="comments"><xsl:value-of select="if ($jobs/@comments) then $jobs/@comments else 0"/></json:number>
    <json:number key="documents"><xsl:value-of select="if ($jobs/@documents) then $jobs/@documents else 0"/></json:number>
    <json:number key="folders"><xsl:value-of select="if ($jobs/@folders) then $jobs/@folders else 0"/></json:number>
    <json:number key="tasks"><xsl:value-of select="if ($jobs/@tasks) then $jobs/@tasks else 0"/></json:number>
    <json:number key="urls"><xsl:value-of select="if ($jobs/@urls) then $jobs/@urls else 0"/></json:number>
  </json:map>
</xsl:template>

<xsl:template match="root[@service='api-admin-indexes']" mode="json">
  <json:map>
    <json:number key="page"><xsl:value-of select="content/indexes/@page" /></json:number>
    <json:number key="pagesize"><xsl:value-of select="content/indexes/@pagesize" /></json:number>
    <json:number key="total"><xsl:value-of select="content/indexes/@total" /></json:number>
    <json:boolean key="hasMore"><xsl:value-of select="content/indexes/@has-more = 'true'" /></json:boolean>
    <json:array key="indexes">
      <xsl:for-each select="content/indexes/index">
        <json:map>
          <json:string key="id"><xsl:value-of select="@id" /></json:string>
          <xsl:if test="@group"><json:string key="group"><xsl:value-of select="@group" /></json:string></xsl:if>
          <xsl:if test="@error"><json:string key="error"><xsl:value-of select="@error" /></json:string></xsl:if>
          <xsl:if test="@last-modified"><json:string key="lastModified"><xsl:value-of select="@last-modified" /></json:string></xsl:if>
          <xsl:if test="@documents"><json:number key="documents"><xsl:value-of select="@documents"/></json:number></xsl:if>
          <xsl:if test="@deletions"><json:boolean key="deletions"><xsl:value-of select="@deletions = 'true'"/></json:boolean></xsl:if>
        </json:map>
      </xsl:for-each>
    </json:array>
  </json:map>
</xsl:template>

<xsl:template match="root[@service='api-admin-index-fields']" mode="json">
  <json:array>
    <xsl:for-each select="//fields/field">
      <json:map>
        <json:string key="name"><xsl:value-of select="@name" /></json:string>
        <xsl:if test="@documents"><json:number key="documents"><xsl:value-of select="@documents"/></json:number></xsl:if>
      </json:map>
    </xsl:for-each>
  </json:array>
</xsl:template>

<xsl:template match="root[@service='api-admin-index-field-terms']" mode="json">
  <json:array>
    <xsl:for-each select="//terms/term">
      <json:map>
        <json:string key="field"><xsl:value-of select="../@field" /></json:string>
        <json:string key="value"><xsl:value-of select="@value" /></json:string>
        <xsl:if test="@documents"><json:number key="documents"><xsl:value-of select="@documents"/></json:number></xsl:if>
      </json:map>
    </xsl:for-each>
  </json:array>
</xsl:template>

<xsl:template match="root[@service='api-admin-project-catalog']" mode="json">
<json:map>
  <xsl:for-each select="//catalog">
    <json:string key="name"><xsl:value-of select="@name"/></json:string>
    <json:array key="fields">
      <xsl:for-each select="field">
        <json:map>
          <json:string key="name"><xsl:value-of select="@name" /></json:string>
          <json:boolean key="error"><xsl:value-of select="@error = 'true'" /></json:boolean>
          <json:boolean key="stored"><xsl:value-of select="@stored = 'true'" /></json:boolean>
          <json:boolean key="tokenized"><xsl:value-of select="@tokenized = 'true'" /></json:boolean>
          <json:string key="docValues"><xsl:value-of select="@doc-values" /></json:string>
          <xsl:if test="@date-format"><json:string key="dateFormat"><xsl:value-of select="@date-format"/></json:string></xsl:if>
          <xsl:if test="@date-resolution"><json:string key="dateResolution"><xsl:value-of select="@date-resolution"/></json:string></xsl:if>
          <xsl:if test="@numeric-type"><json:string key="numericType"><xsl:value-of select="@numeric-type"/></json:string></xsl:if>
        </json:map>
      </xsl:for-each>
    </json:array>
  </xsl:for-each>
</json:map>
</xsl:template>

</xsl:stylesheet>
