<!--
  ~ Copyright (c) 1999-2018 Allette Systems Pty Ltd
  -->
<xsl:stylesheet version="3.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:json="http://www.w3.org/2005/xpath-functions"
                xmlns:err="http://www.w3.org/2005/xqt-errors"
                exclude-result-prefixes="#all">

<!-- Common JSON/PSML code -->
<xsl:import href="../_common/json.xsl"/>
<xsl:import href="../_common/json-document.xsl"/>
<xsl:import href="../_common/json-config.xsl"/>
<xsl:import href="../_common/psml.xsl"/>

<!-- API Modules -->
<xsl:import href="api/_fallback.xsl"/>
<xsl:import href="api/_functions.xsl"/>
<xsl:import href="api/_new-file-templates.xsl"/>
<xsl:import href="api/api-account-memberships.xsl"/>
<xsl:import href="api/api-admin-email-config.xsl"/>
<xsl:import href="api/api-admin-file.xsl"/>
<xsl:import href="api/api-admin-hosts.xsl"/>
<xsl:import href="api/api-admin-index.xsl"/>
<xsl:import href="api/api-admin-logs.xsl"/>
<xsl:import href="api/api-admin-logs-access.xsl"/>
<xsl:import href="api/api-admin-logs-index.xsl"/>
<xsl:import href="api/api-admin-logs-mail.xsl"/>
<xsl:import href="api/api-admin-logs-process.xsl"/>
<xsl:import href="api/api-admin-logs-publish.xsl"/>
<xsl:import href="api/api-admin-logs-security.xsl"/>
<xsl:import href="api/api-admin-member-managed-groups.xsl"/>
<xsl:import href="api/api-admin-message.xsl"/>
<xsl:import href="api/api-admin-oauth.xsl"/>
<xsl:import href="api/api-admin-organization.xsl"/>
<xsl:import href="api/api-admin-publisher.xsl"/>
<xsl:import href="api/api-admin-server-properties.xsl"/>
<xsl:import href="api/api-admin-statistics.xsl"/>
<xsl:import href="api/api-admin-status.xsl"/>
<xsl:import href="api/api-admin-templates.xsl"/>
<xsl:import href="api/api-admin-threads.xsl"/>
<xsl:import href="api/api-auth.xsl"/>
<xsl:import href="api/api-document.xsl"/>
<xsl:import href="api/api-document-ai.xsl"/>
<xsl:import href="api/api-document-fragment.xsl"/>
<xsl:import href="api/api-document-fragment-compare.xsl"/>
<xsl:import href="api/api-document-fragment-create.xsl"/>
<xsl:import href="api/api-document-fragment-tracker.xsl"/>
<xsl:import href="api/api-document-fragment-transform.xsl"/>
<xsl:import href="api/api-document-info.xsl"/>
<xsl:import href="api/api-document-indexdata.xsl"/>
<xsl:import href="api/api-document-inspect.xsl"/>
<xsl:import href="api/api-document-publish.xsl"/>
<xsl:import href="api/api-document-toc.xsl"/>
<xsl:import href="api/api-document-tracker.xsl"/>
<xsl:import href="api/api-document-tracker-split.xsl"/>
<xsl:import href="api/api-document-xrefs-unresolve.xsl"/>
<xsl:import href="api/api-validation.xsl"/>
<xsl:import href="api/api-feed.xsl"/>
<xsl:import href="api/api-group-admin-bundles.xsl"/>
<xsl:import href="api/api-group-documenttypes.xsl"/>
<xsl:import href="api/api-group-upload-config.xsl"/>
<xsl:import href="api/api-help.xsl"/>
<xsl:import href="api/api-loadingzone-inspect.xsl"/>
<xsl:import href="api/api-member.xsl"/>
<xsl:import href="api/api-project-labels.xsl"/>
<xsl:import href="api/api-project-documenttypes.xsl"/>
<xsl:import href="api/api-project-admin-files.xsl"/>
<xsl:import href="api/api-search.xsl"/>
<xsl:import href="api/api-session-file.xsl"/>
<xsl:import href="api/api-url.xsl"/>

<!-- General Output properties. -->
<xsl:output method="text" encoding="utf-8" indent="no" media-type="application/json"/>

<!-- FIXME The current group -->
<xsl:variable name="current-group" select="/root/header/uri-parameters/parameter[@name='group'][1]"/>

<!--
  Main template called in all cases.
-->
<xsl:template match="/">
  <xsl:variable name="json">
    <xsl:apply-templates mode="json"/>
  </xsl:variable>
  <xsl:try>
    <xsl:value-of select="json:xml-to-json($json)"/>
    <xsl:catch>
      <xsl:variable name="error">
        <json:map>
          <json:string key="error">Failed to build JSON from XML: <xsl:value-of select="$err:description" /></json:string>
          <json:string key="code"><xsl:value-of select="$err:code" /></json:string>
          <json:string key="json"><xsl:value-of select="serialize($json)" /></json:string>
        </json:map>
      </xsl:variable>
      <xsl:value-of select="json:xml-to-json($error)"/>
    </xsl:catch>
  </xsl:try>
</xsl:template>

<!-- Error handling -->
<xsl:template match="root[content/error]" mode="json">
  <xsl:choose>
    <xsl:when test="@service='api-document' and content/@status='not-found'">
      <json:map>
        <json:map key="document">
          <xsl:variable name="uri" select="(//uri)[1]" />
          <xsl:if test="$uri/@id"><json:number key="id"><xsl:value-of select="$uri/@id"/></json:number></xsl:if>
          <json:string key="schemaversion">1.4</json:string>
          <json:string key="status"/>
          <json:string key="version">current</json:string>
          <json:string key="level">processed</json:string>
          <json:boolean key="lockstructure">false</json:boolean>
          <json:boolean key="readonly">false</json:boolean>
          <json:boolean key="hasNumbering">false</json:boolean>
          <json:boolean key="isBroken">true</json:boolean>
          <json:string key="publicationid"/>
          <json:string key="type"/>
          <json:number key="position">1</json:number>
          <json:string key="date"><xsl:value-of select="if ($uri/@modified) then $uri/@modified else $uri/@created"/></json:string>
          <xsl:apply-templates select="if ($uri) then ($uri) else documentinfo/uri" mode="json">
            <xsl:with-param name="key" select="'uri'"/>
          </xsl:apply-templates>
          <json:array key="versions"/>
          <json:array key="reversexrefs"/>
          <json:array key="locators"/>
          <json:array key="xrefs"/>
          <json:array key="links"/>
          <json:array key="images"/>
          <json:array key="structure"/>
          <json:array key="fragments" />
        </json:map>
        <xsl:apply-templates select="content/document-type|content/document-extension|content/url-type" mode="api-document-json"/>
      </json:map>
    </xsl:when>
    <xsl:when test="count(content/error) = 1">
      <json:map key="error">
        <json:string key="id"><xsl:value-of select="content/error/@id" /></json:string>
        <json:string key="message"><xsl:value-of select="content/error/message" /></json:string>
      </json:map>
    </xsl:when>
    <xsl:otherwise>
      <json:array>
        <xsl:for-each select="content/error">
          <json:map>
            <json:string key="id"><xsl:value-of select="@id" /></json:string>
            <json:string key="message"><xsl:value-of select="message" /></json:string>
          </json:map>
        </xsl:for-each>
      </json:array>
    </xsl:otherwise>
  </xsl:choose>
</xsl:template>

</xsl:stylesheet>
