<?xml version="1.0" encoding="UTF-8"?>
<!--
  ~ Copyright (c) 1999-2019 Allette Systems Pty Ltd
-->
<xsl:stylesheet version="2.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:xs="http://www.w3.org/2001/XMLSchema"
                xmlns:v-bind="https://vuejs.org"
                xmlns:f="http://www.pageseeder.com/function"
                xmlns:json="http://www.w3.org/2005/xpath-functions"
                exclude-result-prefixes="#all">

<xsl:template match="root[@service='legal']" mode="html-title" as="xs:string*">
  <xsl:sequence select="('Legal')"/>
</xsl:template>

<xsl:template match="root[@service='legal']" mode="main-content">
<div class="main-content">
  <main-panel>
    <centered-box wide="">
      <!-- NB We use the `.legal-document` class to display in `legal-dialog` -->
      <article class="legal-document">
        <div class="psml-content">
          <xsl:if test="not(//document/fragment) and content/error">
            <callout-box type="error">
              <p>This document is not available.</p>
            </callout-box>
          </xsl:if>
          <xsl:apply-templates select="//document/fragment/*" mode="psml-edit"/>
        </div>
      </article>
      <public-content class="text-center">
        <a class="button" href="{$site-prefix}/">OK</a>
      </public-content>
    </centered-box>
  </main-panel>
</div>
</xsl:template>

</xsl:stylesheet>
