<?xml version="1.0" encoding="UTF-8"?>
<!--
  ~ Copyright (c) 1999-2019 Allette Systems Pty Ltd
  -->
<xsl:stylesheet version="2.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:xs="http://www.w3.org/2001/XMLSchema"
                xmlns:v-bind="https://vuejs.org"
                exclude-result-prefixes="#all">

<xsl:template match="root[@service='project-home']" mode="html-title" as="xs:string*">
  <xsl:sequence select="('Home')"/>
</xsl:template>

<xsl:template match="root[@service='project-home']" mode="main-content">
<xsl:variable name="opentask-count" select="//facet[@name='psstatus']/term[@text='Open']/@cardinality"/>
<xsl:variable name="comment-count" select="//facet[@name='pstype']/term[@text='comment']/@cardinality"/>
<xsl:variable name="document-count" select="//facet[@name='pstype']/term[@text='document']/@cardinality"/>
<project-banner v-bind:index-available="{//facets/@indexes != ''}"
                v-bind:tasks="{if ($opentask-count) then $opentask-count else 0}"
                v-bind:comments="{if ($comment-count) then $comment-count else 0}"
                v-bind:documents="{if ($document-count) then $document-count else 0}"/>
<div class="main-content">
  <main-panel>
    <features-box />
    <project-feed />
  </main-panel>
  <side-panel side="right"/>
</div>
</xsl:template>

</xsl:stylesheet>
