<?xml version="1.0" encoding="UTF-8"?>
<!--
  ~ Copyright (c) 1999-2019 Allette Systems Pty Ltd
  -->
<xsl:stylesheet version="2.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:xs="http://www.w3.org/2001/XMLSchema"
                xmlns:v-bind="https://vuejs.org"
                xmlns:f="http://www.pageseeder.com/function"
                xmlns:json="http://www.w3.org/2005/xpath-functions"
                exclude-result-prefixes="#all">

<xsl:template match="root[@service='group-search']" mode="html-title" as="xs:string*">
  <xsl:sequence select="('Search')"/>
</xsl:template>

<xsl:template match="root[@service='group-search']" mode="main-content">
<xsl:variable name="publish-actions">
  <json:array><xsl:apply-templates select="content/publish-config/publishing/action/target" mode="json" /></json:array>
</xsl:variable>

<search-bar v-bind:publish-actions="{f:xml-to-json($publish-actions)}" />
<div class="main-content">
  <main-panel full-width="">
    <search-results />
  </main-panel>
  <side-panel side="right"/>
</div>
</xsl:template>

</xsl:stylesheet>
