<?xml version="1.0" encoding="UTF-8"?>
<!--
  ~ Copyright (c) 1999-2019 Allette Systems Pty Ltd
  -->
<xsl:stylesheet version="2.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:xs="http://www.w3.org/2001/XMLSchema"
                xmlns:f="http://www.pageseeder.com/function"
                xmlns:v-bind="https://vuejs.org"
                xmlns:json="http://www.w3.org/2005/xpath-functions"
                exclude-result-prefixes="#all">

<xsl:template match="root[@service='group-comment-moderate']" mode="html-title" as="xs:string*">
  <xsl:sequence select="('Moderate comment')"/>
</xsl:template>

<xsl:template match="root[@service='group-comment-moderate']" mode="main-content">
  <div class="main-content">
    <main-panel>
      <div class="container">
        <xsl:variable name="discussion"><xsl:apply-templates select="content/discussion" mode="json" /></xsl:variable>
        <xsl:variable name="comment-id" select="//parameter[@name='id']"/>
        <comment-moderation v-bind:discussion="{f:xml-to-json($discussion)}"
                            v-bind:comment-id="{if ($comment-id) then $comment-id else 'null'}" />
      </div>
    </main-panel>
    <side-panel side="right"/>
  </div>
</xsl:template>

</xsl:stylesheet>
