<?xml version="1.0" encoding="UTF-8"?>
<!--
  ~ Copyright (c) 1999-2019 Allette Systems Pty Ltd
  -->
<xsl:stylesheet version="2.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:xs="http://www.w3.org/2001/XMLSchema"
                xmlns:v-bind="https://vuejs.org"
                exclude-result-prefixes="#all">

<xsl:template match="root[@service='document-view']" mode="html-title" as="xs:string*">
  <xsl:variable name="title" select="content/context/uri/displaytitle"/>
  <xsl:sequence select="($title)"/>
</xsl:template>

<xsl:template match="root[@service='document-view']" mode="main-content">
  <document-bar />
  <!-- TODO Vue3 v-bind:class="{{'is-saving': useEditingStore().progress !== -1}}" -->
  <div class="main-content" >
    <document-left-side-bar />
    <side-panel side="left" v-bind:width="400" />

    <main-panel full-width="">
      <document-toolbar/>
      <editing-errors/>
      <document-main/>
    </main-panel>

    <side-panel side="right"/>
    <document-right-side-bar />
  </div>
</xsl:template>

</xsl:stylesheet>
