<?xml version="1.0" encoding="UTF-8"?>
<!--
  ~ Copyright (c) 1999-2018 Allette Systems Pty Ltd
  -->
<xsl:stylesheet version="2.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:json="http://www.w3.org/2005/xpath-functions"
                xmlns:f="http://www.pageseeder.com/function"
                xmlns:v-bind="https://vuejs.org"
                exclude-result-prefixes="#all">

<xsl:template match="root[@group='admin']" mode="main-side-nav">
  <admin-side-nav v-cloak="" active-page="{f:_service-active-page(@service, //parameter)}"/>
</xsl:template>

<xsl:function name="f:_service-active-page">
  <xsl:param name="service"/>
  <xsl:param name="parameters" as="element()*"/>
  <xsl:choose>
    <xsl:when test="$service = 'admin-hosts' and $parameters[@name='external'] = 'true'"><xsl:value-of select="concat($service, '-external')"/></xsl:when>
    <xsl:otherwise><xsl:value-of select="$service"/></xsl:otherwise>
  </xsl:choose>
</xsl:function>

</xsl:stylesheet>