<?xml version="1.0" encoding="UTF-8"?>
<!--
  ~ Copyright (c) 1999-2020 Allette Systems Pty Ltd
-->
<xsl:stylesheet version="2.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:xs="http://www.w3.org/2001/XMLSchema"
                xmlns:f="http://www.pageseeder.com/function"
                xmlns:json="http://www.w3.org/2005/xpath-functions"
                xmlns:v-bind="https://vuejs.org"
                exclude-result-prefixes="#all">

<xsl:template match="root[@service='project-admin-config']" mode="html-title" as="xs:string*">
  <xsl:sequence select="('Project configuration')"/>
</xsl:template>

<xsl:template match="root[@service='project-admin-config']" mode="main-content">
<xsl:variable name="moderator" select="(content//membership[@role='moderator' or @role='moderator-and-approver']/member)[1]" />
<xsl:variable name="project-properties">
  <json:array>
    <xsl:for-each select="content/properties/property[@source = 'project']">
      <xsl:sort select="f:group-property-title(@name)" />
      <json:map>
        <json:string key="name"><xsl:value-of select="@name"/></json:string>
        <json:string key="title"><xsl:value-of select="f:group-property-title(@name)"/></json:string>
        <json:string key="value"><xsl:value-of select="@value"/></json:string>
      </json:map>
    </xsl:for-each>
  </json:array>
</xsl:variable>
<xsl:variable name="emaildomain" select="if (//constants/@email-domain = 'pshosts') then content/context/defaulthost else //constants/@email-domain"/>

<div class="main-content">
  <main-panel>
    <h1 class="page-title"><svg-icon name="cog"/> Project configuration</h1>
    <project-configuration email-domain="{$emaildomain}"
                           v-bind:moderator="{f:to-json($moderator)}"
                           v-bind:project="{f:to-json((content/project)[1])}"
                           v-bind:properties="{f:to-json-group-properties(content/properties)}"
                           v-bind:project-properties="{f:xml-to-json($project-properties)}"/>
  </main-panel>
  <side-panel side="right"/>
</div>
</xsl:template>

</xsl:stylesheet>
