<?xml version="1.0" encoding="UTF-8"?>
<!--
  ~ Copyright (c) 1999-2018 Allette Systems Pty Ltd
  -->
<xsl:stylesheet version="2.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:xs="http://www.w3.org/2001/XMLSchema"
                xmlns:v-bind="https://vuejs.org"
                xmlns:f="http://www.pageseeder.com/function"
                xmlns:json="http://www.w3.org/2005/xpath-functions"
                exclude-result-prefixes="#all">

<xsl:template match="root[@service='group-admin-logs-publish']" mode="html-title" as="xs:string*">
  <xsl:sequence select="('Publish logs')"/>
</xsl:template>

<xsl:template match="root[@service='group-admin-logs-publish']" mode="main-content">
<div class="main-content">
  <xsl:variable name="date" select="header//parameter[@name = 'date']" />
  <main-panel>

    <xsl:call-template name="current-server-datetime"/>
    <h1 class="page-title"><svg-icon name="logs"/> Publish logs</h1>

    <xsl:variable name="summary">
      <json:map><xsl:apply-templates select="content/root/summary" mode="json"/></json:map>
    </xsl:variable>
    <logs-viewer type="publish" v-bind:group-id="{content/context/group/@id}" initial-date="{$date}" v-bind:summary="{f:xml-to-json($summary)}"/>

  </main-panel>
  <side-panel side="right"/>
</div>
</xsl:template>

</xsl:stylesheet>
