<?xml version="1.0" encoding="UTF-8"?>
<!--
  ~ Copyright (c) 1999-2018 Allette Systems Pty Ltd
  -->
<xsl:stylesheet version="2.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:xs="http://www.w3.org/2001/XMLSchema"
                xmlns:f="http://www.pageseeder.com/function"
                xmlns:v-bind="https://vuejs.org"
                exclude-result-prefixes="#all">

<xsl:template match="root[@service='admin-project-files']" mode="html-title" as="xs:string*">
  <xsl:sequence select="('Template files')"/>
</xsl:template>

<xsl:template match="root[@service='admin-project-files']" mode="main-content">
<div class="main-content">
  <main-panel>
    <xsl:variable name="project-template" select="content/context/project/@template" />
    <xsl:choose>
      <xsl:when test="contains($current-project, '-') and $current-project != $project-template">
        <h1 class="page-title"><svg-icon name="file-template" /> Template files</h1>
        <p>This subproject uses the <a
            href="{$site-prefix}/ui/admin/p/{$project-template}/files.html"><xsl:value-of select="$project-template" />
        </a> template files. <br />
          To make different customizations for this subproject change the template under <a
              href="{$site-prefix}/ui/p/{$current-project}/admin/config.html">project configuration</a>.</p>
      </xsl:when>
      <xsl:otherwise>
        <admin-template-filetree project-name="{$current-project}"
                                 global-template="{//constants/@global-template}"
                                 initial-location="{//http-parameters/parameter[@name='select']}"
                                 v-bind:initial-filetree="{f:to-json-filetree(content/file)}" />
      </xsl:otherwise>
    </xsl:choose>
  </main-panel>
  <side-panel side="right" v-bind:width="800"/>
</div>
</xsl:template>

</xsl:stylesheet>
