<?xml version="1.0" encoding="UTF-8"?>
<!--
  ~ Copyright (c) 1999-2018 Allette Systems Pty Ltd
  -->
<xsl:stylesheet version="2.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:f="http://www.pageseeder.com/function"
                xmlns:xs="http://www.w3.org/2001/XMLSchema"
                xmlns:v-bind="https://vuejs.org"
                xmlns:json="http://www.w3.org/2005/xpath-functions"
                exclude-result-prefixes="#all">

<xsl:variable name="template-names" select="(
    'accept-comment',
    'auto-responder',
    'change-email-confirm',
    'change-email',
    'change-password',
    'comment-digest',
    'external',
    'membership-accept',
    'membership-complete',
    'membership-confirm',
    'membership-new-member',
    'new-comment',
    'new-member',
    'new-uri',
    'new-version',
    'out-of-office-change',
    'out-of-office-warning',
    'reject-comment',
    'reminder-digest',
    'reset-password-confirm',
    'verification-code'
  )"/>

<xsl:template match="root[@service='admin-project-emails']" mode="html-title" as="xs:string*">
  <xsl:text>Email templates</xsl:text>
</xsl:template>

<xsl:template match="root[@service='admin-project-emails']" mode="main-content">
<xsl:variable name="organization"><xsl:apply-templates select="content/email" mode="organization-xml" /></xsl:variable>
<xsl:variable name="custom-files"  select="content[@name = 'project-files']/file/file" />
<xsl:variable name="email-templates">
  <json:array>
    <xsl:for-each select="$template-names">
      <json:map>
        <json:string key="name"><xsl:value-of select="." /></json:string>
        <json:boolean key="html"><xsl:value-of select="not(empty($custom-files[@name = concat(current(), '.xsl')]))" /></json:boolean>
        <json:boolean key="text"><xsl:value-of select="not(empty($custom-files[@name = concat(current(), '-text.xsl')]))" /></json:boolean>
      </json:map>
    </xsl:for-each>
  </json:array>
</xsl:variable>
<xsl:variable name="custom-notifications">
  <json:array>
    <xsl:for-each select="$custom-files[ends-with(@name, '.xml') and $template-names = tokenize(@name, '\.')[1]]">
      <json:map>
        <json:string key="template"><xsl:value-of select="tokenize(@name, '\.')[1]" /></json:string>
        <json:string key="name"><xsl:value-of select="replace(string-join(tokenize(@name, '\.')[position() != last() and position() != 1], ''), '_', ' ')" /></json:string>
        <json:string key="path"><xsl:value-of select="@path" /></json:string>
      </json:map>
    </xsl:for-each>
  </json:array>
</xsl:variable>
<xsl:variable name="custom-scripts">
  <xsl:variable name="custom-xslts">
    <xsl:for-each select="$custom-files[ends-with(@name, '.xsl')]">
      <xsl:if test="empty($template-names[. = replace(current()/@name, '.xsl$', '')])"><xsl:sequence select="." /></xsl:if>
    </xsl:for-each>
  </xsl:variable>
  <json:array>
    <xsl:for-each select="$custom-xslts//file">
      <json:map>
        <json:string key="name"><xsl:value-of select="@name" /></json:string>
        <json:string key="path"><xsl:value-of select="@path" /></json:string>
      </json:map>
    </xsl:for-each>
  </json:array>
</xsl:variable>
<xsl:variable name="dkim">
  <xsl:if test="content/email/dkim">
    <json:map>
      <json:boolean key="disabled"><xsl:value-of select="string(content/email/dkim/@disabled) = 'true'" /></json:boolean>
      <xsl:if test="content/email/dkim">
        <json:string key="domain"><xsl:value-of select="content/email/dkim/@domain" /></json:string>
        <json:string key="selector"><xsl:value-of select="content/email/dkim/@selector" /></json:string>
      </xsl:if>
    </json:map>
  </xsl:if>
</xsl:variable>
<xsl:variable name="sender">
  <xsl:if test="content/email/sender">
    <json:map>
      <json:string key="name"><xsl:value-of select="content/email/sender/@name" /></json:string>
      <json:string key="email"><xsl:value-of select="content/email/sender/@email" /></json:string>
    </json:map>
  </xsl:if>
</xsl:variable>

<div class="main-content">
  <main-panel>
    <h1 class="page-title"><svg-icon name="file-template"/> Email templates</h1>

    <xsl:variable name="project-template" select="content/context/project/@template" />
    <xsl:choose>
      <xsl:when test="contains($current-project, '-') and $current-project != $project-template">
        <p>This subproject uses the <a
            href="{$site-prefix}/ui/admin/p/{$project-template}/emails.html"><xsl:value-of select="$project-template" />
        </a> template email templates. <br />
          To make different customizations for this subproject change the template under <a
              href="{$site-prefix}/ui/p/{$current-project}/admin/config.html">project configuration</a>.</p>
      </xsl:when>
      <xsl:otherwise>
        <admin-project-emails project="{$current-project}"
                              organization="{$organization}"
                              email-domain="{content/email/emails/@domain}"
                              v-bind:email-templates="{f:xml-to-json($email-templates)}"
                              v-bind:custom-notifications="{f:xml-to-json($custom-notifications)}"
                              v-bind:custom-scripts="{f:xml-to-json($custom-scripts)}">
          <xsl:if test="content/email/*"><xsl:attribute name="edit-organization" /></xsl:if>
          <xsl:if test="$dkim/*"><xsl:attribute name="v-bind:dkim" select="f:xml-to-json($dkim)" /></xsl:if>
          <xsl:if test="$sender/*"><xsl:attribute name="v-bind:email-sender" select="f:xml-to-json($sender)" /></xsl:if>
        </admin-project-emails>
      </xsl:otherwise>
    </xsl:choose>
  </main-panel>
  <side-panel side="right" v-bind:width="800"/>
</div>
</xsl:template>

<xsl:template match="email" mode="organization-xml">
  <xsl:text>&lt;organization project="</xsl:text>
  <xsl:value-of select="@project" />
  <xsl:text>">
</xsl:text>
  <xsl:apply-templates mode="organization-xml"><xsl:with-param name="indent" select="4" /></xsl:apply-templates>
  <xsl:text>  &lt;/organization>
</xsl:text>
</xsl:template>

<xsl:template match="*" mode="organization-xml">
  <xsl:param name="indent" />
  <xsl:for-each select="1 to $indent"><xsl:text> </xsl:text></xsl:for-each>
  <xsl:text/>&lt;<xsl:value-of select="name()" />
  <xsl:for-each select="@*"><xsl:value-of select="concat(' ', name(), '=&quot;', ., '&quot;')" /></xsl:for-each>
  <xsl:choose>
    <xsl:when test="*">
  <xsl:text>&gt;
</xsl:text>
      <xsl:apply-templates select="*|comment()" mode="organization-xml"><xsl:with-param name="indent" select="$indent+2" /></xsl:apply-templates>
      <xsl:for-each select="1 to $indent"><xsl:text> </xsl:text></xsl:for-each>
      <xsl:text/>&lt;/<xsl:value-of select="name()" />&gt;
<xsl:text/>
    </xsl:when>
    <xsl:otherwise> />
</xsl:otherwise>
  </xsl:choose>
</xsl:template>

<!-- ignore sender, dkim and emails elements -->
<xsl:template match="sender | dkim | emails" mode="organization-xml" />

<xsl:template match="comment()" mode="organization-xml">
<xsl:text>
&lt;!-- </xsl:text>
  <xsl:value-of select="." />
  <xsl:text>--></xsl:text>
</xsl:template>

</xsl:stylesheet>
