<?xml version="1.0" encoding="UTF-8"?>
<!--
  ~ Copyright (c) 1999-2018 Allette Systems Pty Ltd
  -->
<xsl:stylesheet version="2.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:xs="http://www.w3.org/2001/XMLSchema"
                exclude-result-prefixes="#all">

<xsl:template match="root[@service='admin-organization']" mode="html-title" as="xs:string*">Organization customization</xsl:template>

<xsl:template match="root[@service='admin-organization']" mode="main-content">
<div class="main-content">
  <main-panel>
    <h1 class="page-title"><svg-icon name="cog"/> Organization settings</h1>

    <xsl:variable name="product-key" select="//property[@name = 'productKey']/@value" />
    <xsl:variable name="global-template" select="//constants/@global-template"/>

    <xsl:choose>
      <!-- Check that the license authorizes it (dev or service provider) -->
      <xsl:when test="not($product-key = 'dev' or (string-length($product-key) = 28 and starts-with($product-key, 's')))">
        <callout-box type="info">
          <p>Your PageSeeder license does not allow you to use an organization customization.</p>
          <p>Organization customization is only enabled for "Developer" and "Service provider" PageSeeder licenses.</p>
        </callout-box>
      </xsl:when>

      <xsl:otherwise>

        <xsl:choose>
          <xsl:when test="not($global-template) or $global-template = ''">
            <callout-box type="info">
              <p>In order to use a server-wide organization customization, you need to specify a <b>global template</b>.</p>
            </callout-box>
          </xsl:when>
          <xsl:otherwise>
            <callout-box type="info">
              <p>The <file-edit-link project="{$global-template}" location="/WEB-INF/config/template/{$global-template}/organization/organization-config.xml">organization config file</file-edit-link>
                is specified in the <b><xsl:value-of select="$global-template"/></b> project (<a href="{$site-prefix}/ui/admin/p/{$global-template}/files.html">see template files</a>).</p>
            </callout-box>
          </xsl:otherwise>
        </xsl:choose>

        <admin-organization project="{$global-template}" />

      </xsl:otherwise>
    </xsl:choose>
  </main-panel>
  <side-panel side="right"/>
</div>
</xsl:template>

</xsl:stylesheet>
