<?xml version="1.0" encoding="UTF-8"?>
<!--
  ~ Copyright (c) 1999-2020 Allette Systems Pty Ltd
  -->
<xsl:stylesheet version="2.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:xs="http://www.w3.org/2001/XMLSchema"
                xmlns:f="http://www.pageseeder.com/function"
                xmlns:v-bind="https://vuejs.org"
                exclude-result-prefixes="#all">

<xsl:template match="root[@service='admin-members-import']" mode="html-title" as="xs:string*">
  <xsl:sequence select="('Import members')"/>
</xsl:template>

<xsl:template match="root[@service='admin-members-import']" mode="main-content">
<div class="main-content">
  <main-panel>
    <h1 class="page-title"><svg-icon name="member-groups"/> Import members<xsl:if test="$current-group or $current-project"> into <xsl:value-of select="if ($current-group) then 'group' else 'project'"/></xsl:if></h1>
    <xsl:apply-templates select="." mode="admin-members-import-get" />
  </main-panel>
  <side-panel side="right"/>
</div>
</xsl:template>

<!-- Build the form -->
<xsl:template match="root" mode="admin-members-import-get">
  <xsl:variable name="group" select="if ($context/group) then $context/group else $context/project"/>
  <admin-members-import>
    <xsl:if test="$group">
      <xsl:variable name="group-json"><xsl:apply-templates select="$group" mode="json" /></xsl:variable>
      <xsl:attribute name="v-bind:initial-group" select="f:xml-to-json($group-json)" />
      <xsl:attribute name="default-role" select="$group/@defaultrole"/>
      <xsl:attribute name="default-notification" select="$group/@defaultnotify"/>
    </xsl:if>
  </admin-members-import>
</xsl:template>

</xsl:stylesheet>
