<?xml version="1.0" encoding="UTF-8"?>
<!--
  ~ Copyright (c) 1999-2018 Allette Systems Pty Ltd
  -->
<xsl:stylesheet version="2.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:xs="http://www.w3.org/2001/XMLSchema"
                xmlns:v-bind="https://vuejs.org"
                xmlns:f="http://www.pageseeder.com/function"
                exclude-result-prefixes="#all">

<xsl:template match="root[@service='group-admin-member-moderate']" mode="html-title" as="xs:string*">
  <xsl:sequence select="('Member moderate')"/>
</xsl:template>

<xsl:template match="root[@service='group-admin-member-moderate']" mode="main-content">
  <xsl:variable name="membership"><xsl:apply-templates select="content/membership" mode="json" /></xsl:variable>
  <div class="main-content">
    <main-panel>
      <h1 class="page-title"><svg-icon name="member-groups"/> Member moderation</h1>

      <xsl:choose>
        <xsl:when test="$membership/*">
          <admin-member-moderate v-bind:membership="{f:xml-to-json($membership)}" />
        </xsl:when>
        <xsl:otherwise>
          <callout-box type="error">
            <p>The member did not request registration to the group.</p>
          </callout-box>
        </xsl:otherwise>
      </xsl:choose>

    </main-panel>
    <side-panel side="right"/>
  </div>
</xsl:template>

</xsl:stylesheet>
