<?xml version="1.0" encoding="UTF-8"?>
<!--
  ~ Copyright (c) 1999-2018 Allette Systems Pty Ltd
  -->
<xsl:stylesheet version="2.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:xs="http://www.w3.org/2001/XMLSchema"
                xmlns:f="http://www.pageseeder.com/function"
                xmlns:json="http://www.w3.org/2005/xpath-functions"
                xmlns:v-bind="https://vuejs.org"
                exclude-result-prefixes="#all">

<xsl:template match="root[@service='admin-logs-security']" mode="html-title" as="xs:string*">
  <xsl:sequence select="('Security logs')"/>
</xsl:template>

<xsl:template match="root[@service='admin-logs-security']" mode="main-content">
<div class="main-content">
  <xsl:variable name="date" select="header//parameter[@name = 'date']" />

  <xsl:variable name="summary">
    <json:map>
      <xsl:for-each select="//summary">
        <json:map key="{@date}">
          <json:number key="infos"><xsl:value-of select="sum(descendant::events/@infos)"/></json:number>
          <json:number key="warnings"><xsl:value-of select="sum(descendant::events/@warnings)"/></json:number>
          <json:number key="errors"><xsl:value-of select="sum(descendant::events/@errors)"/></json:number>
        </json:map>
      </xsl:for-each>
    </json:map>
  </xsl:variable>

  <main-panel>
    <xsl:call-template name="current-server-datetime"/>
    <h1 class="page-title"><svg-icon name="logs"/> Security logs</h1>
    <security-logs initial-date="{$date}" v-bind:summary="{f:xml-to-json($summary)}"/>
  </main-panel>
  <side-panel side="right"/>
</div>
</xsl:template>

</xsl:stylesheet>
