<?xml version="1.0" encoding="UTF-8"?>
<!--
  ~ Copyright (c) 1999-2018 Allette Systems Pty Ltd
  -->
<xsl:stylesheet version="2.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:xs="http://www.w3.org/2001/XMLSchema"
                xmlns:v-bind="https://vuejs.org"
                exclude-result-prefixes="#all">

<xsl:template match="root[@service='admin-logs-access']" mode="html-title" as="xs:string*">
  <xsl:sequence select="('Access logs')"/>
</xsl:template>

<xsl:template match="root[@service='admin-logs-access']" mode="main-content">
<div class="main-content">
  <xsl:variable name="date" select="header//parameter[@name = 'date']" />
  <xsl:variable name="ticket-id" select="header//parameter[@name = 'session']" />

  <main-panel>

    <xsl:call-template name="current-server-datetime"/>
    <h1 class="page-title"><svg-icon name="logs"/> Access logs</h1>

    <access-logs initial-date="{$date}">
      <xsl:if test="$ticket-id">
        <xsl:attribute name="initial-ticket-id" select="$ticket-id"/>
      </xsl:if>
    </access-logs>
  </main-panel>
  <side-panel side="right"/>
</div>
</xsl:template>

</xsl:stylesheet>
