<?xml version="1.0" encoding="UTF-8"?>
<!--
  ~ Copyright (c) 1999-2020 Allette Systems Pty Ltd
  -->
<xsl:stylesheet version="2.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:xs="http://www.w3.org/2001/XMLSchema"
                exclude-result-prefixes="#all">

<xsl:template match="root[@service='admin-license']" mode="html-title" as="xs:string*">
  <xsl:sequence select="('PageSeeder license')"/>
</xsl:template>

<xsl:template match="root[@service='admin-license']" mode="main-content">
<div class="main-content">
  <main-panel>
    <h1 class="page-title"><svg-icon name="cog"/> PageSeeder license</h1>

    <xsl:variable name="setup" select="content/setup"/>

    <license-form initial-email-domain="{$setup/emaildomain}"
                  initial-groups="{$setup/groups}"
                  initial-license-expires="{$setup/licenseexpires}"
                  initial-members="{$setup/members}"
                  initial-product-key="{$setup/productkey}"
                  initial-projects="{$setup/projects}"
                  initial-website-address="{$setup/websiteaddress}" >
      <xsl:choose>
        <xsl:when test="$setup/productkeyinvalid = 'true'">
          <xsl:attribute name="initial-error">Product key does not match the other settings, please check they are entered exactly as per your license.</xsl:attribute>
        </xsl:when>
        <xsl:when test="$setup/licenseexpired = 'true'">
          <xsl:attribute name="initial-error">The PageSeeder license has expired so most admin pages and all email notifications have been disabled.</xsl:attribute>
        </xsl:when>
        <xsl:when test="$setup/organizationdisabled = 'true'">
          <xsl:attribute name="initial-error">Organization customization is disabled, because license type is not "Developer" or "Service provider".</xsl:attribute>
        </xsl:when>
        <xsl:when test="$setup/organizationerror = 'true'">
          <xsl:attribute name="initial-error">Error loading the organization customization, see general logs for details.</xsl:attribute>
        </xsl:when>
      </xsl:choose>
    </license-form>
  </main-panel>
  <side-panel side="right"/>
</div>
</xsl:template>

</xsl:stylesheet>
