<?xml version="1.0" encoding="UTF-8"?>
<!--
  ~ Copyright (c) 1999-2018 Allette Systems Pty Ltd
  -->
<xsl:stylesheet version="2.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:xs="http://www.w3.org/2001/XMLSchema"
                xmlns:f="http://www.pageseeder.com/function"
                xmlns:json="http://www.w3.org/2005/xpath-functions"
                xmlns:v-bind="https://vuejs.org"
                exclude-result-prefixes="#all">

<xsl:template match="root[@service='admin-indexing']" mode="html-title" as="xs:string*">
  <xsl:sequence select="('Server indexing')"/>
</xsl:template>

<xsl:template match="root[@service='admin-indexing' and content/context//property[@name = 'disableIndexing']/@value = 'true']" mode="main-content">
  <div class="main-content">
    <main-panel>
      <xsl:call-template name="current-server-datetime"/>
      <h1 class="page-title"><svg-icon name="system-status"/> Server indexing</h1>
      <callout-box type="info">
        <p>Indexing has been disabled for this server with the group property <i>disableIndexing</i>.</p>
      </callout-box>
    </main-panel>
  </div>
</xsl:template>

<xsl:template match="root[@service='admin-indexing' and content/context//property[@name = 'disableIndexing']/@value = 'false']" mode="main-content">
<div class="main-content">
  <main-panel>
    <xsl:call-template name="current-server-datetime"/>
    <h1 class="page-title"><svg-icon name="system-status"/> Server indexing</h1>

    <xsl:variable name="urls-index-status">
      <xsl:choose>
        <xsl:when test="content/about-index/urls/@version = content/about-index/index/@version">current</xsl:when>
        <xsl:when test="number(content/about-index/urls/@version) ge floor(number(content/about-index/index/@version) div 1000) * 1000">old</xsl:when>
        <xsl:otherwise>obsolete</xsl:otherwise>
      </xsl:choose>
    </xsl:variable>
    <xsl:variable name="about-group-index" select="content/about-index/groups"/>
    <xsl:variable name="all">
      <json:map>
        <json:number key="current"><xsl:value-of select="if ($about-group-index/@current) then $about-group-index/@current else '0'" /></json:number>
        <json:number key="old"><xsl:value-of select="if ($about-group-index/@old) then $about-group-index/@old else '0'" /></json:number>
        <json:number key="obsolete"><xsl:value-of select="if ($about-group-index/@obsolete) then $about-group-index/@obsolete else '0'" /></json:number>
      </json:map>
    </xsl:variable>

    <xsl:variable name="personal-group-index" select="content/about-index/personal-groups"/>
    <xsl:variable name="personal">
      <json:map>
        <json:number key="current"><xsl:value-of select="if ($personal-group-index/@current) then $personal-group-index/@current else '0'" /></json:number>
        <json:number key="old"><xsl:value-of select="if ($personal-group-index/@old) then $personal-group-index/@old else '0'" /></json:number>
        <json:number key="obsolete"><xsl:value-of select="if ($personal-group-index/@obsolete) then $personal-group-index/@obsolete else '0'" /></json:number>
      </json:map>
    </xsl:variable>
    <admin-indexing v-bind:all-counts="{f:xml-to-json($all)}"
                    v-bind:personal-counts="{f:xml-to-json($personal)}"
                    v-bind:projects="{f:to-json-array(content/projects/project)}"
                    v-bind:more-projects="{content/projects/@limitreached = 'true'}"
                    urls-index-status="{$urls-index-status}"/>
  </main-panel>
  <side-panel side="right" v-bind:width="400"/>
</div>
</xsl:template>

</xsl:stylesheet>
