<?xml version="1.0" encoding="UTF-8"?>
<!--
  ~ Copyright (c) 1999-2018 Allette Systems Pty Ltd
  -->
<xsl:stylesheet version="2.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:xs="http://www.w3.org/2001/XMLSchema"
                xmlns:f="http://www.pageseeder.com/function"
                xmlns:v-bind="https://vuejs.org"
                exclude-result-prefixes="#all">

<xsl:template match="root[@service='admin-administrators']" mode="html-title" as="xs:string*">
  <xsl:sequence select="('System admnistrators')"/>
</xsl:template>

<xsl:template match="root[@service='admin-administrators']" mode="main-content">
<div class="main-content">
  <main-panel>
    <h1 class="page-title"><svg-icon name="member-groups"/> Administrators</h1>
    <xsl:variable name="admins" select="content/administrators/member"/>
    <administrators-table v-bind:administrators="{f:to-json-array($admins)}"/>
  </main-panel>
  <side-panel side="right"/>
</div>
</xsl:template>

</xsl:stylesheet>
