<?xml version="1.0" encoding="UTF-8"?>
<!--
  ~ Copyright (c) 1999-2018 Allette Systems Pty Ltd
  -->
<xsl:stylesheet version="2.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:json="http://www.w3.org/2005/xpath-functions"
                exclude-result-prefixes="#all">
<!--
  Displays the current server date and time.
-->
<xsl:template name="current-server-datetime">
  <p class="current-server-time"><svg-icon name="clock"/> Server time: <server-time initial-datetime="{current-dateTime()}"/></p>
</xsl:template>

<!-- For summary logs -->
<xsl:template match="summary" mode="json">
  <json:map key="{@date}">
    <json:number key="infos"><xsl:value-of select="sum(descendant::ticket/@infos)"/></json:number>
    <json:number key="warnings"><xsl:value-of select="sum(descendant::ticket/@warnings)"/></json:number>
    <json:number key="errors"><xsl:value-of select="sum(descendant::ticket/@errors)"/></json:number>
    <json:number key="groups"><xsl:value-of select="count(descendant::group)"/></json:number>
    <json:number key="tickets"><xsl:value-of select="count(descendant::ticket)"/></json:number>
  </json:map>
</xsl:template>

</xsl:stylesheet>