<?xml version="1.0" encoding="UTF-8"?>
<!--
  ~ Copyright (c) 1999-2018 Allette Systems Pty Ltd

  Templates for the 'admin' panels.
-->
<xsl:stylesheet version="2.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                exclude-result-prefixes="#all">

<!-- Import common stylesheets here -->
<xsl:import href="common/app.xsl"/>
<xsl:import href="common/functions.xsl"/>
<xsl:import href="common/app-content.xsl"/>
<xsl:import href="common/side-nav.xsl"/>
<xsl:import href="common/json.xsl"/>

<!-- Common JSON/PSML code -->
<xsl:import href="../_common/json.xsl"/>
<xsl:import href="../_common/psml.xsl"/>

<!-- Import stylesheets specific to each service here -->
<xsl:import href="admin/_logs.xsl"/>
<xsl:import href="admin/admin-administrators.xsl"/>
<xsl:import href="admin/admin-cache.xsl"/>
<xsl:import href="admin/admin-cache-info.xsl"/>
<xsl:import href="admin/admin-database.xsl"/>
<xsl:import href="admin/admin-email.xsl"/>
<xsl:import href="admin/admin-files.xsl"/>
<xsl:import href="admin/admin-groups-create.xsl"/>
<xsl:import href="admin/admin-dashboard.xsl"/>
<xsl:import href="admin/admin-hosts.xsl"/>
<xsl:import href="admin/admin-identity.xsl"/>
<xsl:import href="admin/admin-indexing.xsl"/>
<xsl:import href="admin/admin-icons.xsl"/>
<xsl:import href="admin/admin-license.xsl"/>
<xsl:import href="admin/admin-logs-access.xsl"/>
<xsl:import href="admin/admin-logs-general.xsl"/>
<xsl:import href="admin/admin-logs-index.xsl"/>
<xsl:import href="admin/admin-logs-mail.xsl"/>
<xsl:import href="admin/admin-logs-process.xsl"/>
<xsl:import href="admin/admin-logs-publish.xsl"/>
<xsl:import href="admin/admin-logs-recent.xsl"/>
<xsl:import href="admin/admin-logs-security.xsl"/>
<xsl:import href="admin/admin-members.xsl"/>
<xsl:import href="admin/admin-members-import.xsl"/>
<xsl:import href="admin/admin-member-moderate.xsl"/>
<xsl:import href="admin/admin-member-profile.xsl"/>
<xsl:import href="admin/admin-organization.xsl"/>
<xsl:import href="admin/admin-oauth-access-tokens.xsl"/>
<xsl:import href="admin/admin-oauth-clients.xsl"/>
<xsl:import href="admin/admin-oauth-codes.xsl"/>
<xsl:import href="admin/admin-oauth-refresh-tokens.xsl"/>
<xsl:import href="admin/admin-oauth-webhooks.xsl"/>
<xsl:import href="admin/admin-processes.xsl"/>
<xsl:import href="admin/admin-project-catalog.xsl"/>
<xsl:import href="admin/admin-project-emails.xsl"/>
<xsl:import href="admin/admin-project-files.xsl"/>
<xsl:import href="admin/admin-project-scripts.xsl"/>
<xsl:import href="admin/admin-project-scripts-validate.xsl"/>
<xsl:import href="admin/admin-projects.xsl"/>
<xsl:import href="admin/admin-projects-create.xsl"/>
<xsl:import href="admin/admin-projects-archived.xsl"/>
<xsl:import href="admin/admin-publisher.xsl"/>
<xsl:import href="admin/admin-settings.xsl"/>
<xsl:import href="admin/admin-components.xsl"/>
<xsl:import href="admin/admin-system.xsl"/>
<xsl:import href="admin/admin-templates.xsl"/>
<xsl:import href="admin/admin-templates-global.xsl"/>
<xsl:import href="admin/admin-templates-validate.xsl"/>

<!-- Group admin -->
<xsl:import href="admin/group-admin-dashboard.xsl"/>
<xsl:import href="admin/group-admin-config.xsl"/>
<xsl:import href="admin/group-admin-maintenance.xsl"/>
<xsl:import href="admin/group-admin-logs-index.xsl"/>
<xsl:import href="admin/group-admin-logs-process.xsl"/>
<xsl:import href="admin/group-admin-logs-publish.xsl"/>
<xsl:import href="admin/group-admin-members.xsl"/>
<xsl:import href="admin/group-admin-sharing.xsl"/>
<xsl:import href="admin/admin-group-index.xsl"/>

<!-- Project admin -->
<xsl:import href="admin/project-admin-dashboard.xsl"/>
<xsl:import href="admin/project-admin-types.xsl"/>
<xsl:import href="admin/project-admin-types-validate.xsl"/>
<xsl:import href="admin/project-admin-config.xsl"/>
<xsl:import href="admin/project-admin-labels.xsl"/>
<xsl:import href="admin/project-admin-maintenance.xsl"/>

<!-- General Output properties. -->
<xsl:output method="html" encoding="utf-8" indent="no" undeclare-prefixes="no" media-type="text/html" version="5.0"/>

<!--
  Main template called in all cases.
-->
<xsl:template match="/">
<!-- We declare a namespace for Vue here so that its is not redeclare later for each `v-bind` -->
<html lang="en" xmlns:v-bind="https://vuejs.org">
  <xsl:apply-templates select="root" mode="html-head"/>
  <xsl:apply-templates select="root" mode="html-body"/>
</html>
</xsl:template>

</xsl:stylesheet>
