<?xml version="1.0" encoding="UTF-8"?>
<!--
  ~ Copyright (c) 1999-2019 Allette Systems Pty Ltd
  -->
<xsl:stylesheet version="2.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:xs="http://www.w3.org/2001/XMLSchema"
                xmlns:v-bind="https://vuejs.org"
                exclude-result-prefixes="#all">

<xsl:template match="root[@service='account-url-create']" mode="html-title" as="xs:string*">
  <xsl:sequence select="('Add new URL')"/>
</xsl:template>

<xsl:template match="root[@service='account-url-create']" mode="main-content">
<div class="main-content">
  <main-panel>
    <xsl:variable name="title"><xsl:value-of select="(//parameter[@name='title'])[1]"/></xsl:variable>
    <xsl:variable name="description"><xsl:value-of select="(//parameter[@name='description'])[1]"/></xsl:variable>
    <xsl:variable name="group" select="(//parameter[@name='group'])[1]"/>
    <xsl:variable name="url" select="(//parameter[@name='url'])[1]"/>
    <url-create-form initial-title="{replace($title, '&#xa0;', ' ')}"
                     initial-description="{replace($description, '&#xa0;', ' ')}"
                     initial-group="{$group}"
                     initial-url="{$url}">
    </url-create-form>
  </main-panel>
  <side-panel side="right"/>
</div>
</xsl:template>

</xsl:stylesheet>