<!--
  ~ Copyright (c) 1999-2020 Allette Systems Pty Ltd

  Module defining rules for transcluded content
-->
<xsl:stylesheet version="3.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:json="http://www.w3.org/2005/xpath-functions"
                xmlns:psml="http://pageseeder.com/PSML"
                xmlns:xs="http://www.w3.org/2001/XMLSchema"
                xmlns:v-bind="https://vuejs.org"
                exclude-result-prefixes="#all">

<!-- Process the content of fragments as normal -->
<xsl:template match="fragment" mode="psml-transclude">
  <xsl:apply-templates mode="psml"/>
</xsl:template>

<!-- Process the content of fragments as normal -->
<xsl:template match="media-fragment" mode="psml-transclude">
  <xsl:variable name="content" select="psml:serialize-media-content(*|text(), @mediatype)"/>
  <psml-media mediatype="{@mediatype}" content="{$content}"/>
</xsl:template>

<xsl:template match="properties-fragment" mode="psml-transclude">
<xsl:variable name="properties">
  <json:array key="properties">
    <xsl:apply-templates select="property" mode="json-document"/>
  </json:array>
</xsl:variable>
<psml-properties group-name="{$current-group}"
                 v-bind:properties="{json:xml-to-json($properties)}">
</psml-properties>
</xsl:template>

<xsl:template match="xref-fragment" mode="psml-transclude">
  <xsl:variable name="xrefs">
    <json:array key="xrefs">
      <xsl:apply-templates select="xref|blockxref" mode="json-document"/>
    </json:array>
  </xsl:variable>
  <psml-xref-list group-name="{$current-group}"
                  v-bind:xrefs="{json:xml-to-json($xrefs)}" />
</xsl:template>

<xsl:template match="title" mode="psml-transclude">
<xsl:variable name="contentid" select="generate-id(ancestor::content)" />
<h2 class="psml-section-title" id="fragment-default-toc-{count((preceding::section | ancestor::section)[ancestor::content[generate-id() = $contentid]][title])}">
  <xsl:apply-templates mode="psml"/>
</h2>
</xsl:template>

<!--Ignore these elements they only provide metadata -->
<xsl:template match="documentinfo|locator|metadata|fragmentinfo" mode="psml-transclude"/>

<!-- Stringify XML content ===================================================== -->

<xsl:function name="psml:serialize-media-content" as="xs:string?">
  <xsl:param name="content"   as="node()*"/>
  <xsl:param name="mediatype" as="xs:string"/>
  <xsl:sequence select="
     if ($mediatype = 'application/mathml+xml' or $mediatype = 'image/svg+xml')
       then psml:serialize-as-xhtml5($content)
     else if (ends-with($mediatype, '/xml') or ends-with($mediatype, '+xml'))
       then psml:serialize-as-xml($content)
     else string($content)" />
</xsl:function>

<!--
  Serialize the specified content as XHTML version 5.
  This is mostly used for SVG and MATH which need to use the default namespace to be rendered correctly in HTML.
-->
<xsl:function name="psml:serialize-as-xhtml5">
  <xsl:param name="content" as="node()*"/>
  <xsl:variable name="html5-output" as="element()">
    <output:serialization-parameters xmlns:output="http://www.w3.org/2010/xslt-xquery-serialization">
      <output:method value="xhtml"/>
      <output:html-version value="5"/>
      <output:indent value="no"/>
    </output:serialization-parameters>
  </xsl:variable>
  <xsl:sequence select="serialize($content, $html5-output)"/>
</xsl:function>

<!--
  Serialize the specified as XML with NO indentation
-->
<xsl:function name="psml:serialize-as-xml">
  <xsl:param name="content" as="node()*"/>
  <xsl:variable name="xml-output" as="element()">
    <output:serialization-parameters xmlns:output="http://www.w3.org/2010/xslt-xquery-serialization">
      <output:method value="xml"/>
      <output:indent value="no"/>
    </output:serialization-parameters>
  </xsl:variable>
  <xsl:sequence select="serialize($content, $xml-output)"/>
</xsl:function>

</xsl:stylesheet>
