<!--
  ~ Copyright (c) 1999-2019 Allette Systems Pty Ltd
  -->
<xsl:stylesheet version="3.0"
                xmlns:json="http://www.w3.org/2005/xpath-functions"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:xs="http://www.w3.org/2001/XMLSchema"
                xmlns:diff="https://www.pageseeder.org/diffx"
                xmlns:track="https://www.pageseeder.org/diffx/track"
                xmlns:del="https://www.pageseeder.org/diffx/delete"
                xmlns:ins="https://www.pageseeder.org/diffx/insert"
                xmlns:psml="http://pageseeder.com/PSML"
                exclude-result-prefixes="#all">

<xsl:template match="document" mode="json-document">
  <xsl:param name="key"/>
  <xsl:variable name="requires-gutter" select="count((descendant::heading|descendant::para)[@prefix or @numbered]) gt 0"/>
  <json:map>
    <xsl:if test="$key"><xsl:attribute name="key" select="$key"/></xsl:if>
    <xsl:if test="@id"><json:number key="id"><xsl:value-of select="@id"/></json:number></xsl:if>
    <json:string key="schemaversion"><xsl:value-of select="@schemaversion"/></json:string>
    <json:string key="status"><xsl:value-of select="@status"/></json:string>
    <json:string key="version"><xsl:value-of select="@version"/></json:string>
    <json:string key="level"><xsl:value-of select="@level"/></json:string>
    <json:boolean key="lockstructure"><xsl:value-of select="@lockstructure = 'true'"/></json:boolean>
    <json:boolean key="readonly"><xsl:value-of select="@edit = 'false'"/></json:boolean>
    <json:boolean key="hasNumbering"><xsl:value-of select="$requires-gutter"/></json:boolean>
    <json:string key="publicationid"><xsl:value-of select="@publicationid"/></json:string>
    <json:string key="type"><xsl:value-of select="@type"/></json:string>
    <xsl:if test="@position">
      <json:number key="position"><xsl:value-of select="@position"/></json:number>
    </xsl:if>
    <xsl:if test="@date">
      <json:string key="date"><xsl:value-of select="@date"/></json:string>
    </xsl:if>
    <xsl:variable name="uri" select="(//uri[sharing][@id = current()/@id])[1]" />
    <xsl:apply-templates select="if ($uri) then ($uri) else documentinfo/uri" mode="json">
      <xsl:with-param name="key" select="'uri'"/>
    </xsl:apply-templates>
    <json:boolean key="hasMoreVersions"><xsl:value-of select="documentinfo/versions/@limitreached = 'true'" /></json:boolean>
    <json:array key="versions">
      <xsl:apply-templates select="documentinfo/versions/version" mode="json"/>
    </json:array>
    <json:array key="reversexrefs">
      <xsl:apply-templates select="documentinfo/descendant::reversexref" mode="json-document"/>
    </json:array>
    <json:array key="locators">
      <xsl:apply-templates select="fragmentinfo/locator" mode="json-document"/>
    </json:array>
    <json:array key="xrefs">
      <xsl:apply-templates select="descendant::xref|descendant::blockxref" mode="json-document"/>
    </json:array>
    <json:array key="links">
      <xsl:apply-templates select="descendant::link" mode="json-document"/>
    </json:array>
    <json:array key="images">
      <xsl:apply-templates select="descendant::image" mode="json-document"/>
    </json:array>
    <!-- If this is a comparison -->
    <xsl:apply-templates select="documentinfo/compareto" mode="json-document">
      <xsl:with-param name="key">compareto</xsl:with-param>
    </xsl:apply-templates>

    <xsl:apply-templates select="metadata" mode="json-document"/>
    <json:array key="structure">
      <xsl:apply-templates select="section|toc" mode="json-document"/>
    </json:array>
    <json:array key="fragments">
      <!-- Insert all current fragments -->
      <xsl:apply-templates select="(section|fragments)/(fragment|media-fragment|properties-fragment|xref-fragment)[not(@deleted='true')]" mode="json-document"/>
      <!-- Insert deleted fragments -->
      <xsl:if test="documentinfo/compareto">
        <xsl:variable name="current-ids" select="(section|fragments)/(fragment|media-fragment|properties-fragment|xref-fragment)[not(@deleted='true')]/@id" as="xs:string*"/>
        <xsl:for-each select="fragmentinfo/locator//(fragment|media-fragment|properties-fragment|xref-fragment)[@del:id]">
          <xsl:if test="not($current-ids[. = current()/@del:id])">
            <json:map>
              <json:string key="id"><xsl:value-of select="@del:id"/></json:string>
              <json:boolean key="deleted">true</json:boolean>
              <json:string key="is"><xsl:value-of select="name(.)"/></json:string>
              <json:string key="type"><xsl:value-of select="@del:type"/></json:string>
              <json:array key="labels"/>
              <json:string key="html"/>
              <json:string key="htmlEdit"/>
              <json:string key="psml"/>
              <!-- Required for media fragments -->
              <json:string key="mediatype"><xsl:value-of select="@del:mediatype"/></json:string>
              <json:string key="content"></json:string>
            </json:map>
          </xsl:if>
        </xsl:for-each>
      </xsl:if>
    </json:array>
  </json:map>
</xsl:template>

<xsl:template match="locator" mode="json-document">
  <xsl:param name="key"/>
  <json:map>
    <xsl:if test="$key"><xsl:attribute name="key" select="$key"/></xsl:if>
    <xsl:if test="@id">
      <json:number key="id"><xsl:value-of select="@id"/></json:number>
    </xsl:if>
    <json:string key="fragment"><xsl:value-of select="@fragment"/></json:string>
    <xsl:if test="@editid">
      <json:number key="editid"><xsl:value-of select="@editid"/></json:number>
    </xsl:if>
    <xsl:if test="compare/@editid">
      <json:number key="compareeditid"><xsl:value-of select="compare/@editid"/></json:number>
    </xsl:if>
    <xsl:if test="@modified">
      <json:string key="modified"><xsl:value-of select="@modified"/></json:string>
    </xsl:if>
    <json:array key="notes">
      <xsl:apply-templates select="descendant::note" mode="json-document"/>
    </json:array>
    <json:array key="reversexrefs">
      <xsl:apply-templates select="descendant::reversexref" mode="json-document"/>
    </json:array>
    <xsl:if test="compare">
      <xsl:apply-templates select="compare/content/*" mode="json-document">
        <xsl:with-param name="key">compare</xsl:with-param>
      </xsl:apply-templates>
      <xsl:variable name="diff" select="if (count(compare/diff/*) gt 1) then compare/diff/*[@diff:insert = 'true'] else compare/diff/*" />
      <xsl:apply-templates select="$diff" mode="json-document">
        <xsl:with-param name="key">diff</xsl:with-param>
      </xsl:apply-templates>
    </xsl:if>
  </json:map>
</xsl:template>

<xsl:template match="compareto" mode="json-document">
  <xsl:param name="key"/>
  <xsl:variable name="compareuriid" select="//parameter[@name='compareuriid']"/>
  <xsl:variable name="uri" select="ancestor::documentinfo/uri"/>
  <xsl:variable name="content-locators" select="//locator[not(@fragment='default')]" />
  <json:map>
    <xsl:if test="$key"><xsl:attribute name="key" select="$key"/></xsl:if>
    <json:number key="id"><xsl:value-of select="if ($compareuriid and $compareuriid castable as xs:int) then $compareuriid else ancestor::document/@id"/></json:number>
    <json:string key="title"><xsl:value-of select="title"/></json:string>
    <json:string key="version"><xsl:value-of select="@version"/></json:string>
    <json:string key="date"><xsl:value-of select="@date"/></json:string>
    <json:string key="docid"><xsl:value-of select="@docid"/></json:string>
    <json:string key="description"><xsl:value-of select="description"/></json:string>
    <json:array key="labels">
      <xsl:for-each select="tokenize(labels, ',')"><json:string><xsl:value-of select="."/></json:string></xsl:for-each>
    </json:array>
    <!-- We store here differences between the URI -->
    <json:map key="diff">
      <json:string key="title"><xsl:value-of select="$uri/@title"/></json:string>
      <json:string key="docid"><xsl:value-of select="$uri/@docid"/></json:string>
      <json:string key="description"><xsl:value-of select="$uri/description"/></json:string>
      <json:array key="labels">
        <xsl:for-each select="tokenize($uri/labels, ',')"><json:string><xsl:value-of select="."/></json:string></xsl:for-each>
      </json:array>
    </json:map>
    <json:map key="stats">
      <json:number key="charsTotal">
        <xsl:variable name="content"><xsl:value-of select="//section/*"/></xsl:variable>
        <xsl:value-of select="string-length(normalize-space($content))"/>
      </json:number>
      <json:number key="charsInserted">
        <xsl:variable name="ins"><xsl:value-of select="//diff:ins"/></xsl:variable>
        <xsl:value-of select="string-length(normalize-space($ins))"/>
      </json:number>
      <json:number key="charsDeleted">
        <xsl:variable name="del"><xsl:value-of select="//diff:del"/></xsl:variable>
        <xsl:value-of select="string-length(normalize-space($del))"/>
      </json:number>
      <xsl:variable name="view-structure">
        <xsl:if test="ancestor::document/metadata">metadata|</xsl:if>
        <xsl:value-of select="ancestor::document//section[not(@deleted)]/(@id|*[not(@deleted)]/@id)" separator="|"/>
      </xsl:variable>
      <xsl:variable name="compare-structure">
        <xsl:if test="metadata">metadata|</xsl:if>
        <xsl:value-of select="//section-ref/(@id|*/@id)" separator="|"/>
      </xsl:variable>
      <json:boolean key="hasMetadataChanges">
        <xsl:value-of select="count(//locator[@fragment='default']/compare/diff) gt 0"/>
      </json:boolean>
      <json:boolean key="hasStructuralChanges">
        <xsl:value-of select="$view-structure != $compare-structure"/>
      </json:boolean>
      <xsl:variable name="compare-info">
        <xsl:value-of select="title|description|@docid|labels" separator="|"/>
      </xsl:variable>
      <xsl:variable name="view-info">
        <xsl:value-of select="$uri/@title|$uri/description|$uri/@docid|$uri/labels" separator="|"/>
      </xsl:variable>
      <json:boolean key="hasInfoChanges">
        <xsl:value-of select="$view-info != $compare-info"/>
      </json:boolean>
      <json:boolean key="hasModifications">
        <xsl:value-of select="count($content-locators//(@ins:*|@del:*|@diff:*)) gt 0"/>
      </json:boolean>
    </json:map>
    <xsl:apply-templates select="metadata" mode="json-document" />
    <json:array key="structure">
       <xsl:for-each select="structure/*">
         <json:map>
           <json:string key="is"><xsl:value-of select="if (self::section-ref) then 'section' else 'toc'"/></json:string>
           <xsl:if test="self::section-ref">
             <json:string key="id"><xsl:value-of select="@id"/></json:string>
             <json:string key="title"><xsl:value-of select="@title"/></json:string>
             <json:string key="heading"><xsl:value-of select="title"/></json:string>
             <json:array key="fragmentRefs">
               <xsl:for-each select="fragment-ref">
                 <json:string><xsl:value-of select="@id"/></json:string>
               </xsl:for-each>
             </json:array>
           </xsl:if>
           <!-- Could be TOC, no more attributes -->
         </json:map>
       </xsl:for-each>
    </json:array>
  </json:map>
</xsl:template>

<xsl:template match="note" mode="json-document">
  <xsl:param name="key"/>
  <json:map>
    <xsl:if test="$key"><xsl:attribute name="key" select="$key"/></xsl:if>
    <json:string key="content"><xsl:value-of select="content"/></json:string>
    <xsl:if test="@id">
      <json:number key="id"><xsl:value-of select="@id"/></json:number>
    </xsl:if>
    <json:string key="modified"><xsl:value-of select="@modified"/></json:string>
    <json:string key="title"><xsl:value-of select="@title"/></json:string>
    <json:array key="labels">
      <xsl:for-each select="tokenize(labels, ',')"><json:string><xsl:value-of select="."/></json:string></xsl:for-each>
    </json:array>
    <xsl:apply-templates select="author" mode="json">
      <xsl:with-param name="key" select="'author'"/>
    </xsl:apply-templates>
  </json:map>
</xsl:template>

<xsl:template match="reversexref" mode="json-document">
  <xsl:param name="key"/>
  <json:map>
    <xsl:if test="$key"><xsl:attribute name="key" select="$key"/></xsl:if>
    <json:string key="docid"><xsl:value-of select="@docid"/></json:string>
    <xsl:if test="@documenttype">
      <json:string key="documenttype"><xsl:value-of select="@documenttype"/></json:string>
    </xsl:if>
    <json:string key="forwardtitle"><xsl:value-of select="@forwardtitle"/></json:string>
    <json:string key="forwardtype"><xsl:value-of select="@forwardtype"/></json:string>
    <json:string key="forwarddisplay"><xsl:value-of select="@forwarddisplay"/></json:string>
    <json:string key="forwardfrag"><xsl:value-of select="@forwardfrag"/></json:string>
    <json:string key="frag"><xsl:value-of select="@frag"/></json:string>
    <json:string key="href"><xsl:value-of select="@href"/></json:string>
    <xsl:if test="@id">
      <json:number key="id"><xsl:value-of select="@id"/></json:number>
    </xsl:if>
    <json:array key="labels">
      <xsl:for-each select="tokenize(@labels, ',')"><json:string><xsl:value-of select="."/></json:string></xsl:for-each>
    </json:array>
    <json:boolean key="local"><xsl:value-of select="starts-with(@href, concat($site-prefix,'/',translate($current-group, '-', '/'),'/'))"/></json:boolean>
    <xsl:if test="@level">
      <json:number key="level"><xsl:value-of select="@level"/></json:number>
    </xsl:if>
    <json:string key="mediatype"><xsl:value-of select="@mediatype"/></json:string>
    <!-- Stop gap solution to recompute the forward title -->
    <xsl:variable name="self" select="."/>
    <xsl:if test="@forwarddisplay = 'template' and @forwardfrag != 'default'">
      <xsl:variable name="fragment" select="//fragment[@id = current()/@forwardfrag]"/>
      <json:string key="text">
        <xsl:analyze-string select="@forwardtitle" regex="\{{[^}}]+\}}">
          <xsl:matching-substring>
            <xsl:choose>
              <!-- {prefix}: the @prefix of the first heading or para in the target fragment (<xref> only).-->
              <xsl:when test=". = '{prefix}'"><xsl:value-of select="($fragment//*[@prefix])[1]/@prefix"/></xsl:when>
              <!-- {heading}: the text of the first heading or property in the target fragment (<xref> only). The property can not have type xref or markdown or have multiple values.-->
              <xsl:when test=". = '{heading}'"><xsl:value-of select="($fragment//heading)[1]"/></xsl:when>
              <!-- {fragment}: target fragment ID.-->
              <xsl:when test=". = '{fragment}'"><xsl:value-of select="$self/@forwardfrag"/></xsl:when>
              <!-- {document}: display title of the target document.-->
              <xsl:when test=". = '{document}'"><xsl:value-of select="$self/ancestor::document/documentinfo/uri/@title"/></xsl:when>
              <!-- {filename}: filename of the target document.-->
              <xsl:when test=". = '{filename}'"><xsl:value-of select="tokenize($self/ancestor::document/documentinfo/uri/@decodedpath, '/')[last()]"/></xsl:when>
              <!-- {docid}: docid of the target document.-->
              <xsl:when test=". = '{docid}'"><xsl:value-of select="$self/ancestor::document/documentinfo/uri/@docid"/></xsl:when>
              <!-- TODO {parentnumber}: the number of the parent heading or para for the target fragment (<xref> only).-->
              <xsl:when test=". = '{parentnumber}'"><xsl:value-of select="''"/></xsl:when>
              <xsl:otherwise><xsl:value-of select="."/></xsl:otherwise>
            </xsl:choose>
          </xsl:matching-substring>
          <xsl:non-matching-substring><xsl:value-of select="."/></xsl:non-matching-substring>
        </xsl:analyze-string>
      </json:string>
    </xsl:if>
    <json:string key="title"><xsl:value-of select="@title"/></json:string>
    <json:string key="type"><xsl:value-of select="@type"/></json:string>
    <xsl:if test="@uriid">
      <json:number key="uriid"><xsl:value-of select="@uriid"/></json:number>
    </xsl:if>
    <json:string key="urititle"><xsl:value-of select="@urititle"/></json:string>
    <json:array key="urilabels">
      <xsl:for-each select="tokenize(@urilabels, ',')"><json:string><xsl:value-of select="."/></json:string></xsl:for-each>
    </json:array>
    <xsl:if test="@urltype">
      <json:string key="urltype"><xsl:value-of select="@urltype"/></json:string>
    </xsl:if>
  </json:map>
</xsl:template>

<xsl:template match="xref|blockxref" mode="json-document">
  <xsl:param name="key"/>
  <json:map>
    <xsl:if test="$key"><xsl:attribute name="key" select="$key"/></xsl:if>
    <json:string key="is"><xsl:value-of select="local-name()"/></json:string>
    <!-- TODO in v6, we can remove the check on `/archive/`, we keep this because cached doc might not have the archived flag -->
    <json:boolean key="archived"><xsl:value-of select="@archived = 'true' or contains(@href, '/archive/')" /></json:boolean>
    <xsl:if test="@config or @del:config">
      <json:string key="config"><xsl:value-of select="(@config, @del:config)[1]"/></json:string>
    </xsl:if>
    <json:string key="display"><xsl:value-of select="(@display, @del:display)[1]"/></json:string>
    <json:string key="docid"><xsl:value-of select="(@docid, @del:docid)[1]"/></json:string>
    <json:string key="documenttype"><xsl:value-of select="(@documenttype, @del:documenttype)[1]"/></json:string>
    <json:boolean key="external"><xsl:value-of select="@external = 'true' or @del:external = 'true'"/></json:boolean>
    <json:string key="frag"><xsl:value-of select="(@frag, @del:frag)[1]"/></json:string>
    <json:string key="href"><xsl:value-of select="(@href, @del:href)[1]"/></json:string>
    <xsl:if test="@id">
      <json:number key="id"><xsl:value-of select="(@id, @del:id)[1]"/></json:number>
    </xsl:if>
    <json:boolean key="local"><xsl:value-of select="starts-with((@href, @del:href)[1], concat($site-prefix,'/',translate($current-group, '-', '/'),'/'))"/></json:boolean>
    <json:array key="labels">
      <xsl:for-each select="tokenize(@labels, ',')"><json:string><xsl:value-of select="."/></json:string></xsl:for-each>
    </json:array>
    <xsl:if test="@level or @del:level">
      <json:number key="level"><xsl:value-of select="(@level, @del:level)[1]"/></json:number>
    </xsl:if>
    <json:string key="mediatype"><xsl:value-of select="(@mediatype, @del:mediatype)[1]"/></json:string>
    <json:string key="reversefrag"><xsl:value-of select="(@reversefrag, @del:reversefrag)[1]"/></json:string>
    <json:boolean key="reverselink"><xsl:value-of select="@reverselink = 'true' or @del:reverselink = 'true'"/></json:boolean>
    <json:string key="reversetitle"><xsl:value-of select="(@reversetitle, @del:reversetitle)[1]"/></json:string>
    <json:string key="reversetype"><xsl:value-of select="(@reversetype, @del:reversetype)[1]"/></json:string>
    <json:string key="text"><xsl:value-of select="text()|diff:ins|track:span"/></json:string>
    <json:string key="title"><xsl:value-of select="(@title, @del:title)[1]"/></json:string>
    <json:string key="type"><xsl:value-of select="(@type, @del:type)[1]"/></json:string>
    <json:boolean key="unresolved"><xsl:value-of select="@unresolved = 'true'"/></json:boolean>
    <xsl:if test="@uriid or @del:uriid">
      <json:number key="uriid"><xsl:value-of select="(@uriid, @del:uriid)[1]"/></json:number>
    </xsl:if>
    <json:string key="urititle"><xsl:value-of select="(@urititle, @del:urititle)[1]"/></json:string>
    <json:array key="urilabels">
      <xsl:for-each select="tokenize((@urilabels, @del:urilabels)[1], ',')"><json:string><xsl:value-of select="."/></json:string></xsl:for-each>
    </json:array>
    <xsl:if test="@type = 'transclude'">
      <json:string key="html">
        <xsl:variable name="html">
          <xsl:apply-templates select="descendant::fragment|descendant::properties-fragment|descendant::media-fragment|descendant::xref-fragment" mode="psml"/>
        </xsl:variable>
        <xsl:value-of select="serialize($html)"/>
      </json:string>
    </xsl:if>
    <xsl:apply-templates select="." mode="json-diff"/>
  </json:map>
</xsl:template>

<xsl:template match="link" mode="json-document">
  <xsl:param name="key"/>
  <json:map>
    <xsl:if test="$key"><xsl:attribute name="key" select="$key"/></xsl:if>
    <json:boolean key="archived"><xsl:value-of select="@archived = 'true'" /></json:boolean>
    <json:string key="href"><xsl:value-of select="@href"/></json:string>
    <json:string key="role"><xsl:value-of select="@role"/></json:string>
    <json:string key="text"><xsl:value-of select="."/></json:string>
    <!-- Added to locate the link inside the document -->
    <json:string key="reversefrag"><xsl:value-of select="(ancestor::fragment|ancestor::xref-fragment|ancestor::properties-fragment)/@id" /></json:string>
    <xsl:if test="@uriid">
      <json:number key="uriid"><xsl:value-of select="@uriid" /></json:number>
    </xsl:if>
    <xsl:if test="@urltype">
      <json:string key="urltype"><xsl:value-of select="@urltype" /></json:string>
    </xsl:if>
    <xsl:if test="@mediatype">
      <json:string key="mediatype"><xsl:value-of select="@mediatype" /></json:string>
    </xsl:if>
    <xsl:if test="@unresolved">
      <json:boolean key="unresolved"><xsl:value-of select="@unresolved = 'true'" /></json:boolean>
    </xsl:if>
    <xsl:if test="@labels">
      <json:array key="labels">
        <xsl:for-each select="tokenize(@labels, ',')"><json:string><xsl:value-of select="."/></json:string></xsl:for-each>
      </json:array>
    </xsl:if>
    <xsl:apply-templates select="." mode="json-diff"/>
  </json:map>
</xsl:template>

<xsl:template match="image" mode="json-document">
  <json:map>
    <json:string key="src"><xsl:value-of select="@src"/></json:string>
    <json:string key="docid"><xsl:value-of select="@docid"/></json:string>
    <json:boolean key="archived"><xsl:value-of select="@archived = 'true'" /></json:boolean>
    <!-- Added to locate the image inside the document -->
    <json:string key="reversefrag"><xsl:value-of select="(ancestor::fragment|ancestor::xref-fragment|ancestor::properties-fragment)/@id" /></json:string>
    <xsl:if test="@uriid">
      <json:number key="uriid"><xsl:value-of select="@uriid"/></json:number>
    </xsl:if>
    <json:string key="alt"><xsl:value-of select="@alt"/></json:string>
    <xsl:if test="@height">
      <json:number key="height"><xsl:value-of select="@height"/></json:number>
    </xsl:if>
    <json:boolean key="unresolved"><xsl:value-of select="@unresolved = 'true'"/></json:boolean>
    <xsl:if test="@width">
      <json:number key="width"><xsl:value-of select="@width"/></json:number>
    </xsl:if>
    <xsl:if test="@labels">
      <json:array key="labels">
        <xsl:for-each select="tokenize(@labels, ',')"><json:string><xsl:value-of select="."/></json:string></xsl:for-each>
      </json:array>
    </xsl:if>
  </json:map>
</xsl:template>

<xsl:template match="metadata" mode="json-document">
  <json:map key="metadata">
    <xsl:if test="@editid">
      <json:number key="editid"><xsl:value-of select="@editid"/></json:number>
    </xsl:if>
    <json:string key="modified"><xsl:value-of select="@modified"/></json:string>
    <json:array key="properties">
      <xsl:apply-templates select="properties/property" mode="json-document"/>
    </json:array>
    <!-- TODO notes -->
  </json:map>
</xsl:template>

<xsl:template match="content/properties|diff/properties" mode="json-document">
  <xsl:param name="key"/>
  <json:map>
    <xsl:if test="$key"><xsl:attribute name="key" select="$key"/></xsl:if>
    <json:array key="properties">
      <xsl:apply-templates select="property" mode="json-document"/>
    </json:array>
  </json:map>
</xsl:template>

<xsl:template match="property" mode="json-document">

  <xsl:variable name="multiple" select="((@count and @count != '1')
                                       or @multiple='true'
                                       or (@del:multiple='true' and @diff:delete='true'))
                                    and not(@datatype = 'markdown' or @datatype = 'markup')"/>
  <json:map>
    <json:boolean key="multiple"><xsl:value-of select="$multiple"/></json:boolean>
    <json:string key="name"><xsl:value-of select="if (@name != '') then @name else @del:name"/></json:string>
    <json:string key="title"><xsl:value-of select="@title"/></json:string>
    <xsl:if test="@datatype">
      <json:string key="datatype"><xsl:value-of select="@datatype"/></json:string>
    </xsl:if>
    <xsl:choose>
      <xsl:when test="$multiple">
        <json:array key="values">
          <!-- We don't include deleted content values (handled elsewhere) -->
          <xsl:apply-templates select="xref|link|(value|markdown)[not(@diff:delete='true' or (diff:del and normalize-space(.) = diff:del) or (track:del and normalize-space(.) = track:del))]" mode="json-document"/>
        </json:array>
      </xsl:when>
      <xsl:when test="xref">
        <xsl:apply-templates select="xref" mode="json-document">
          <xsl:with-param name="key">xref</xsl:with-param>
        </xsl:apply-templates>
      </xsl:when>
      <xsl:when test="link">
        <xsl:apply-templates select="link" mode="json-document">
          <xsl:with-param name="key">link</xsl:with-param>
        </xsl:apply-templates>
      </xsl:when>
      <xsl:when test="@datatype = 'markup'">
        <json:string key="value">
          <xsl:value-of select="serialize(*[not(@diff:delete='true')])"/>
        </json:string>
      </xsl:when>
      <xsl:when test="@datatype = 'markdown'">
        <json:string key="value">
          <xsl:apply-templates select="markdown[not(@diff:delete='true')]/*|markdown[not(@diff:delete='true' and (diff:del and normalize-space(.) = diff:del))]/text()" mode="markdown"/>
        </json:string>
      </xsl:when>
      <xsl:otherwise>
        <!-- We don't include deleted content values (handled elsewhere) -->
        <json:string key="value"><xsl:value-of select="@value|(value|markdown)[not(@diff:delete='true' or (diff:del and normalize-space(.) = diff:del) or (track:del and normalize-space(.) = track:del))]"/></json:string>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates select="." mode="json-diff"/>
  </json:map>
</xsl:template>

<xsl:template match="property/value" mode="json-document">
  <!-- We don't include deleted content values (handled elsewhere) -->
  <xsl:variable name="inserted"><xsl:value-of select="string-join(text()|diff:ins|diff:span|track:ins|track:span, '')"/></xsl:variable>
  <json:string><xsl:value-of select="normalize-space($inserted)"/></json:string>
</xsl:template>

<xsl:template match="property/markdown" mode="json-document">
  <json:string><xsl:apply-templates select="*|text()" mode="markdown"/></json:string>
</xsl:template>

<!--
  We insert the escaped diff tags to be processed by the markdown processor,
  as an alternative we could use a markdown syntax, there is one for `del` (~~) but not for `ins`.
  Or we could proprocess the HTML
-->
<xsl:template match="diff:ins" mode="markdown">&lt;ins><xsl:value-of select="."/>&lt;/ins></xsl:template>
<xsl:template match="diff:del" mode="markdown">&lt;del><xsl:value-of select="."/>&lt;/del></xsl:template>

<xsl:template match="section" mode="json-document">
  <json:map>
    <json:string key="is">section</json:string>
    <json:boolean key="readonly"><xsl:value-of select="@edit = 'false'"/></json:boolean>
    <json:string key="id"><xsl:value-of select="@id"/></json:string>
    <json:boolean key="lockstructure"><xsl:value-of select="@lockstructure = 'true'"/></json:boolean>
    <json:boolean key="overwrite"><xsl:value-of select="not(@overwrite = 'false')"/></json:boolean>
    <json:string key="title"><xsl:value-of select="@title"/></json:string>
    <json:string key="heading"><xsl:value-of select="title"/></json:string>
    <xsl:if test="@deleted = 'true'">
      <json:boolean key="deleted">true</json:boolean>
    </xsl:if>
    <xsl:if test="string(title[1]) != ''">
      <xsl:variable name="docid" select="generate-id(ancestor::document)" />
      <json:string key="tocRef">fragment-default-toc-<xsl:value-of select="count(preceding::section[ancestor::document[generate-id() = $docid]][string(title[1]) != ''])+1" /></json:string>
    </xsl:if>
    <xsl:if test="@fragmenttype">
      <json:array key="fragmentTypes">
        <xsl:for-each select="tokenize(@fragmenttype, ',')">
          <json:string><xsl:value-of select="." /></json:string>
        </xsl:for-each>
      </json:array>
    </xsl:if>
    <json:array key="fragmentRefs">
      <xsl:for-each select="fragment|media-fragment|properties-fragment|xref-fragment">
        <json:string><xsl:value-of select="@id" /></json:string>
      </xsl:for-each>
    </json:array>
  </json:map>
</xsl:template>

<xsl:template match="toc" mode="json-document">
  <json:map>
    <json:string key="is">toc</json:string>
  </json:map>
</xsl:template>

<xsl:template match="fragment|media-fragment|properties-fragment|xref-fragment" mode="json-document">
  <xsl:param name="key"/>
  <json:map>
    <xsl:if test="$key"><xsl:attribute name="key" select="$key"/></xsl:if>
    <json:boolean key="deleted"><xsl:value-of select="@deleted = 'true'"/></json:boolean>
    <json:string key="id"><xsl:value-of select="@id"/></json:string>
    <json:string key="is"><xsl:value-of select="local-name()"/></json:string>
    <json:string key="type"><xsl:value-of select="@type"/></json:string>
    <json:array key="labels">
      <xsl:for-each select="tokenize(@labels, ',')"><json:string><xsl:value-of select="."/></json:string></xsl:for-each>
    </json:array>

    <xsl:variable name="is-combined" select="not(count(ancestor::document/@tracking) gt 0 or //parameter[@name='compare-diffx'] = 'split')"/>
    <xsl:choose>
      <xsl:when test="$is-combined">
        <!-- Any change in labels in combined view (we can use the labels attributes) -->
        <xsl:if test="@del:labels or @ins:labels = 'true'">
          <xsl:variable name="labels" select="tokenize(@labels, ',')" />
          <xsl:variable name="old-labels" select="tokenize(@del:labels, ',')" />
          <json:array key="diffLabels">
            <xsl:for-each select="$labels">
              <json:map>
                <json:string key="name"><xsl:sequence select="." /></json:string>
                <xsl:if test="empty($old-labels[. = current()])">
                  <json:boolean key="ins">true</json:boolean>
                </xsl:if>
              </json:map>
            </xsl:for-each>
            <xsl:for-each select="$old-labels[not(.=$labels)]">
              <json:map>
                <json:string key="name"><xsl:sequence select="." /></json:string>
                <json:boolean key="del">true</json:boolean>
              </json:map>
            </xsl:for-each>
          </json:array>
        </xsl:if>
      </xsl:when>
      <xsl:otherwise>
        <!-- Any change in labels in Split view (we need the locator in that case) -->
        <xsl:if test="@del:labels or @ins:labels">
          <xsl:variable name="locator"    select="//locator[@fragment = current()/@id]"/>
          <xsl:variable name="labels"     select="tokenize($locator/labels, ',')" />
          <xsl:variable name="old-labels" select="tokenize($locator/compare/labels, ',')" />
          <json:array key="diffLabels">
            <xsl:for-each select="$labels[.=$old-labels]">
              <json:map>
                <json:string key="name"><xsl:sequence select="." /></json:string>
              </json:map>
            </xsl:for-each>
            <xsl:if test="not(ancestor::diff)">
              <xsl:for-each select="$labels[not(.=$old-labels)]">
                <json:map>
                  <json:string key="name"><xsl:sequence select="." /></json:string>
                  <json:boolean key="ins">true</json:boolean>
                </json:map>
              </xsl:for-each>
            </xsl:if>
            <xsl:if test="ancestor::diff">
              <xsl:for-each select="$old-labels[not(.=$labels)]">
                <json:map>
                  <json:string key="name"><xsl:sequence select="." /></json:string>
                  <json:boolean key="del">true</json:boolean>
                </json:map>
              </xsl:for-each>
            </xsl:if>
          </json:array>
        </xsl:if>

      </xsl:otherwise>

    </xsl:choose>

    <xsl:apply-templates select="." mode="json-content"/>
  </json:map>
</xsl:template>

<xsl:template match="fragment" mode="json-content">
  <json:string key="html">
    <xsl:variable name="html">
      <xsl:apply-templates select="*|text()" mode="psml"/>
    </xsl:variable>
    <xsl:value-of select="serialize($html)"/>
  </json:string>
  <json:string key="htmlEdit">
    <xsl:variable name="html-edit">
      <xsl:apply-templates select="*|text()" mode="psml-edit"/>
    </xsl:variable>
    <xsl:value-of select="serialize($html-edit)"/>
  </json:string>
  <json:string key="psml">
    <xsl:apply-templates select="." mode="psml-source"/>
  </json:string>
</xsl:template>

<xsl:template match="media-fragment" mode="json-content">
  <xsl:variable name="is-combined" select="not(count(ancestor::document/@tracking) gt 0 or //parameter[@name='compare-diffx'] = 'split')"/>
  <json:string key="mediatype"><xsl:value-of select="@mediatype"/></json:string>
  <xsl:if test="parent::diff or ancestor::document/@tracking or track:*">
    <json:boolean key="diff">true</json:boolean>
  </xsl:if>
  <json:string key="content">
    <xsl:choose>
      <xsl:when test="$is-combined and parent::diff and @mediatype = 'application/mathml+xml'">
        <xsl:variable name="math">
          <xsl:apply-templates select="ancestor::document//section/media-fragment[@id = current()/@id]" mode="mathml-ins"/>
          <xsl:apply-templates select="parent::diff/preceding-sibling::content/*" mode="mathml-del"/>
        </xsl:variable>
        <xsl:value-of select="psml:serialize-as-xhtml5($math)"/>
      </xsl:when>
      <xsl:when test="$is-combined and parent::diff and @mediatype = 'image/svg+xml'">
        <xsl:variable name="svg">
          <xsl:apply-templates select="ancestor::document//section/media-fragment[@id = current()/@id]" mode="svg-ins"/>
          <xsl:apply-templates select="parent::diff/preceding-sibling::content/*" mode="svg-del"/>
        </xsl:variable>
        <xsl:value-of select="psml:serialize-as-xhtml5($svg)"/>
      </xsl:when>
      <xsl:when test="@mediatype = 'application/mathml+xml'">
        <xsl:variable name="math">
          <xsl:apply-templates select="*|text()" mode="mathml-track"/>
        </xsl:variable>
        <xsl:value-of select="psml:serialize-as-xhtml5($math)"/>
      </xsl:when>
      <xsl:when test="@mediatype = 'image/svg+xml'">
        <xsl:variable name="svg">
          <xsl:apply-templates select="*|text()" mode="svg-track"/>
        </xsl:variable>
        <xsl:value-of select="psml:serialize-as-xhtml5($svg)"/>
      </xsl:when>
      <xsl:when test="ends-with(@mediatype, '/xml') or ends-with(@mediatype, '+xml')">
        <xsl:value-of select="serialize(*|text())"/>
      </xsl:when>
      <xsl:when test="diff:ins|diff:del|track:ins|track:del|track:span">
        <xsl:variable name="diff"><xsl:apply-templates select="*|text()" mode="psml"/></xsl:variable>
        <xsl:value-of select="serialize($diff)"/>
      </xsl:when>
      <xsl:otherwise>
        <xsl:value-of select="text()"/>
      </xsl:otherwise>
    </xsl:choose>
  </json:string>
  <json:string key="psml">
    <xsl:apply-templates select="." mode="psml-source"/>
  </json:string>
</xsl:template>

<xsl:template match="properties-fragment" mode="json-content">
  <json:array key="properties">
    <xsl:apply-templates select="property" mode="json-document"/>
  </json:array>
  <json:string key="psml">
    <xsl:apply-templates select="." mode="psml-source"/>
  </json:string>
</xsl:template>

<xsl:template match="xref-fragment" mode="json-content">
  <json:array key="xrefs">
    <xsl:apply-templates select="xref|blockxref" mode="json-document"/>
  </json:array>
  <json:string key="psml">
    <xsl:apply-templates select="." mode="psml-source"/>
  </json:string>
</xsl:template>

<!--
  Insert the attributes from the diff into the property
-->
<xsl:template match="property" mode="json-diff">
  <!-- In split mode, we can use @tracking attribute -->
  <xsl:variable name="ins" select="ancestor::document/@tracking='ins'
                                or ancestor::document[not(@tracking)] and not(ancestor::diff)"/>
  <!-- Inserted/deleted property (We rely on @name rather than insert/delete flag) -->
  <xsl:if test="@ins:name or (@track:name and $ins)">
    <json:boolean key="inserted">true</json:boolean>
  </xsl:if>
  <xsl:if test="@del:name or (@track:name and not($ins))">
    <json:boolean key="deleted">true</json:boolean>
  </xsl:if>
  <!-- Tracker (record most recent edit i.e. max editid) -->
  <xsl:if test="@track:value castable as xs:integer
             or @track:title castable as xs:integer
             or value/track:*/@editid">
    <xsl:variable name="editid" select="max((@track:value, @track:title, value/track:*/@editid))"/>
    <xsl:variable name="edit" select="ancestor::document//edit[@id=$editid]"/>
    <xsl:variable name="values" select="value/track:*[@editid]"/>
    <xsl:for-each select="($edit)[1]">
      <json:map key="edit">
        <json:number key="id"><xsl:value-of select="@id" /></json:number>
        <json:string key="created"><xsl:value-of select="@created" /></json:string>
        <xsl:apply-templates select="author" mode="json" />
        <json:array key="values">
          <xsl:for-each select="$values">
            <json:string><xsl:value-of select="." /></json:string>
          </xsl:for-each>
        </json:array>
      </json:map>
    </xsl:for-each>
  </xsl:if>
  <xsl:if test="@ins:* or @track:* or value[@diff:insert or diff:ins or track:ins]">
    <json:map key="ins">
      <!-- Classic diff -->
      <xsl:for-each select="@ins:*">
        <json:string key="{local-name()}"><xsl:value-of select="../@*[name() = local-name(current())]"/></json:string>
      </xsl:for-each>
      <!-- Tracker (split) -->
      <xsl:if test="ancestor::document/@tracking='ins'"><!-- XXX -->
        <xsl:for-each select="@track:*">
          <json:string key="{local-name()}"><xsl:value-of select="../@*[name() = local-name(current())]"/></json:string>
        </xsl:for-each>
      </xsl:if>
      <!-- Inserted property values -->
      <xsl:if test="value[@diff:insert or diff:ins or track:ins]">
        <json:array key="values">
          <xsl:for-each select="value[@diff:insert or diff:ins or track:ins]">
            <xsl:variable name="inserted"><xsl:value-of select="string-join(text()|diff:ins|track:ins, '')"/></xsl:variable>
            <json:string><xsl:value-of select="normalize-space($inserted)"/></json:string>
          </xsl:for-each>
        </json:array>
      </xsl:if>
    </json:map>
  </xsl:if>
  <xsl:if test="@del:* or @track:* or value[@diff:delete or diff:del or track:del]
                                   or value[text()][diff:ins or track:ins][not(@diff:insert)]">
    <json:map key="del">
      <!-- Classic diff -->
      <xsl:for-each select="@del:*">
        <json:string key="{local-name()}"><xsl:value-of select="."/></json:string>
      </xsl:for-each>
      <!-- Tracker (split) -->
      <xsl:if test="not($ins)">
        <xsl:for-each select="@track:*">
          <json:string key="{local-name()}"><xsl:value-of select="../@*[name() = local-name(current())]"/></json:string>
        </xsl:for-each>
      </xsl:if>
      <!-- Deleted property values -->
      <xsl:if test="value[@diff:delete or diff:del or track:del]
                 or value[text()][diff:ins or track:ins][not(@diff:insert)]">
        <json:array key="values">
          <xsl:for-each select="value[@diff:delete or diff:del or track:del]|value[text()][diff:ins or track:ins][not(@diff:insert)]">
            <xsl:variable name="deleted"><xsl:value-of select="string-join(text()|diff:del|track:del, '')"/></xsl:variable>
            <json:string><xsl:value-of select="normalize-space($deleted)"/></json:string>
          </xsl:for-each>
        </json:array>
      </xsl:if>
    </json:map>
  </xsl:if>
</xsl:template>

<!--
  Insert the attributes from the diff into the xref
-->
<xsl:template match="blockxref|xref|link" mode="json-diff">
  <xsl:if test="@diff:insert">
    <json:boolean key="inserted">true</json:boolean>
  </xsl:if>
  <xsl:if test="@diff:delete">
    <json:boolean key="deleted">true</json:boolean>
  </xsl:if>
  <!-- Tracker (record most recent edit i.e. max editid) -->
  <xsl:if test="track:*[@editid]">
    <xsl:variable name="editid" select="max(track:*/@editid)"/>
    <xsl:variable name="edit" select="ancestor::document//edit[@id=$editid]"/>
    <xsl:for-each select="($edit)[1]">
      <json:map key="edit">
        <json:number key="id"><xsl:value-of select="@id" /></json:number>
        <json:string key="created"><xsl:value-of select="@created" /></json:string>
        <xsl:apply-templates select="author" mode="json" />
      </json:map>
    </xsl:for-each>
  </xsl:if>
  <xsl:if test="@ins:* or diff:ins or track:ins or (not(ancestor::diff) and @diff:* except @diff:insert)">
    <json:map key="ins">
      <!-- TODO Adjust for datatypes of xref -->
      <xsl:for-each select="@ins:*">
        <json:string key="{local-name()}"><xsl:value-of select="../@*[name() = local-name(current())]"/></json:string>
      </xsl:for-each>
      <xsl:for-each select="@diff:* except @diff:insert">
        <json:string key="{local-name()}"><xsl:value-of select="../@*[name() = local-name(current())]"/></json:string>
      </xsl:for-each>
      <!-- Inserted text -->
      <xsl:if test="diff:ins or track:ins">
        <xsl:variable name="inserted"><xsl:value-of select="string-join(text()|diff:ins|track:ins, '')"/></xsl:variable>
        <json:string key="text"><xsl:value-of select="normalize-space($inserted)"/></json:string>
      </xsl:if>
    </json:map>
  </xsl:if>
  <xsl:if test="@del:* or diff:del or track:del or (ancestor::diff and @diff:* except @diff:delete)">
    <json:map key="del">
      <!-- TODO Adjust for datatypes of xref -->
      <xsl:for-each select="@del:*">
        <json:string key="{local-name()}"><xsl:value-of select="."/></json:string>
      </xsl:for-each>
      <xsl:for-each select="@diff:* except @diff:delete">
        <json:string key="{local-name()}"><xsl:value-of select="../@*[name() = local-name(current())]"/></json:string>
      </xsl:for-each>
      <!-- Deleted text -->
      <xsl:if test="diff:del or track:del or (text() and diff:ins)">
        <xsl:variable name="deleted"><xsl:value-of select="string-join(text()|diff:del|track:del, '')"/></xsl:variable>
        <json:string key="text"><xsl:value-of select="normalize-space($deleted)"/></json:string>
      </xsl:if>
    </json:map>
  </xsl:if>
</xsl:template>

<xsl:template match="text()" mode="psml-edit">
  <xsl:analyze-string select="." regex="&#xA0;">
    <xsl:matching-substring>
      <span class="mce-nbsp-wrap mce-nbsp" contenteditable="false">
        <xsl:value-of select="."/>
      </span>
    </xsl:matching-substring>
    <xsl:non-matching-substring>
      <xsl:value-of select="."/>
    </xsl:non-matching-substring>
  </xsl:analyze-string>
</xsl:template>

</xsl:stylesheet>