<!--
  ~ Copyright (c) 1999-2019 Allette Systems Pty Ltd
  -->
<xsl:stylesheet version="3.0"
                xmlns:t="http://pageseeder.com/psml/template"
                xmlns:json="http://www.w3.org/2005/xpath-functions"
                xmlns:xs="http://www.w3.org/2001/XMLSchema"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                exclude-result-prefixes="#all">

<!--
  PSML documents
-->
<xsl:template match="document-type" mode="json-config">
  <json:map>
    <xsl:for-each select="@name|@definedby">
      <json:string key="{name()}"><xsl:value-of select="."/></json:string>
    </xsl:for-each>
    <json:string key="icon"><xsl:value-of select="$site-prefix" /><xsl:value-of select="@icon" /></json:string>
    <xsl:if test="@css and not(ends-with(@css, 'psml-content.css'))">
      <json:string key="css"><xsl:value-of select="$site-prefix" /><xsl:value-of select="@css" /></json:string>
    </xsl:if>
    <xsl:apply-templates select="document-config"   mode="json-config">
      <xsl:with-param name="key" select="'config'"/>
    </xsl:apply-templates>
    <xsl:apply-templates select="document-template" mode="json-config">
      <xsl:with-param name="key" select="'template'"/>
    </xsl:apply-templates>
    <xsl:apply-templates select="editor-configs"    mode="json-config">
      <xsl:with-param name="key" select="'editorConfigs'"/>
    </xsl:apply-templates>
    <xsl:if test="help">
      <json:map key="help">
        <json:string key="format"><xsl:value-of select="help/@type" /></json:string>
        <json:string key="content"><xsl:value-of select="help" /></json:string>
      </json:map>
    </xsl:if>
  </json:map>
</xsl:template>

<!--
  non-PSML documents
-->
<xsl:template match="document-extension" mode="json-config">
  <json:map>
    <xsl:apply-templates select="media-template" mode="json-config">
      <xsl:with-param name="key" select="'template'"/>
    </xsl:apply-templates>
    <xsl:apply-templates select="editor-configs"    mode="json-config">
      <xsl:with-param name="key" select="'editorConfigs'"/>
    </xsl:apply-templates>
    <json:map key="config">
      <xsl:apply-templates select="label-config" mode="json-config" />
    </json:map>
    <xsl:if test="help">
      <json:map key="help">
        <json:string key="format"><xsl:value-of select="help/@type" /></json:string>
        <json:string key="content"><xsl:value-of select="help" /></json:string>
      </json:map>
    </xsl:if>
  </json:map>
</xsl:template>

<xsl:template match="document-config|url-config" mode="json-config">
  <xsl:param name="key"/>
  <json:map>
    <xsl:if test="$key"><xsl:attribute name="key" select="$key"/></xsl:if>
    <xsl:if test="@source">
      <json:string key="source"><xsl:value-of select="@source"/></json:string>
    </xsl:if>
    <xsl:apply-templates select="creation|editing|labeling|publishing|roles" mode="json-config"/>

    <!-- We're adding the xref config here too -->
    <xsl:apply-templates select="../xref-configs" mode="json-config"/>
  </json:map>
</xsl:template>

<xsl:template match="creation" mode="json-config">
  <json:map key="creation">
    <json:boolean key="disable"><xsl:value-of select="@disable = 'true'"/></json:boolean>
    <json:string key="title"><xsl:value-of select="title"/></json:string>
    <json:string key="description"><xsl:value-of select="description"/></json:string>
    <xsl:apply-templates select="document|filename|folder" mode="json-config"/>
    <xsl:if test="domain">
      <json:array key="domains">
        <xsl:for-each select="domain">
          <json:string><xsl:value-of select="@name" /></json:string>
        </xsl:for-each>
      </json:array>
    </xsl:if>
    <xsl:if test="media">
      <json:array key="mediatypes">
        <xsl:for-each select="media">
          <json:string><xsl:value-of select="@type" /></json:string>
        </xsl:for-each>
      </json:array>
    </xsl:if>
  </json:map>
</xsl:template>

<xsl:template match="creation/folder" mode="json-config">
  <json:map key="folder">
    <json:string key="context"><xsl:value-of select="@context"/></json:string>
    <json:string key="path"><xsl:value-of select="@path"/></json:string>
    <json:string key="transform"><xsl:value-of select="@transform"/></json:string>
  </json:map>
</xsl:template>

<xsl:template match="creation/filename" mode="json-config">
  <json:map key="filename">
    <json:string key="value"><xsl:value-of select="@value"/></json:string>
    <json:string key="transform"><xsl:value-of select="@transform"/></json:string>
    <json:boolean key="editable"><xsl:value-of select="@editable = 'true'"/></json:boolean>
  </json:map>
</xsl:template>

<xsl:template match="creation/document" mode="json-config">
  <json:map key="document">
    <json:string key="title"><xsl:value-of select="@title"/></json:string>
    <json:string key="labels"><xsl:value-of select="@labels"/></json:string>
    <json:string key="docid"><xsl:value-of select="@docid"/></json:string>
    <json:string key="description"><xsl:value-of select="@description"/></json:string>
    <json:string key="publicationid"><xsl:value-of select="@publicationid"/></json:string>
    <json:string key="publicationtype"><xsl:value-of select="@publicationtype"/></json:string>
  </json:map>
</xsl:template>

<xsl:template match="editing" mode="json-config">
  <json:array key="editors">
    <xsl:for-each select="editor[options/@editnote][not(@format)]">
      <json:map>
        <!-- From v5.9904, we ignore the @name, @format and @mediatype attributes -->
        <json:string key="fragmenttype"><xsl:value-of select="if (@fragmenttype) then @fragmenttype else '*'"/></json:string>
        <!-- From v5.9904, we only support the @editnote attributes -->
        <xsl:for-each select="options/@editnote">
          <json:string key="editnote"><xsl:value-of select="."/></json:string>
        </xsl:for-each>
      </json:map>
    </xsl:for-each>
  </json:array>
</xsl:template>

<xsl:template match="labeling | label-config" mode="json-config">
  <json:array key="labels">
    <xsl:for-each select="labels">
      <xsl:variable name="type" select="@type"/>
      <xsl:for-each select="label">
        <json:map>
          <json:string key="type"><xsl:value-of select="$type"/></json:string>
          <json:string key="name"><xsl:value-of select="@name"/></json:string>
          <json:string key="description"><xsl:value-of select="@description"/></json:string>
          <json:string key="color"><xsl:value-of select="@color"/></json:string>
          <xsl:if test="string(@fragmenttypes) != ''">
            <json:array key="fragmenttypes">
              <xsl:for-each select="tokenize(@fragmenttypes, ',')">
                <json:string><xsl:value-of select="."/></json:string>
              </xsl:for-each>
            </json:array>
          </xsl:if>
        </json:map>
      </xsl:for-each>
    </xsl:for-each>
  </json:array>
</xsl:template>

<xsl:template match="roles" mode="json-config">
  <json:array key="roles">
    <xsl:for-each select="role">
      <json:map>
        <json:string key="type"><xsl:value-of select="@type"/></json:string>
        <json:string key="name"><xsl:value-of select="@name"/></json:string>
        <json:string key="description"><xsl:value-of select="@description"/></json:string>
      </json:map>
    </xsl:for-each>
  </json:array>
</xsl:template>

<xsl:template match="document-template|media-template|url-template" mode="json-config">
  <xsl:param name="key"/>
  <json:map>
    <xsl:if test="$key"><xsl:attribute name="key" select="$key"/></xsl:if>
    <json:string key="type"><xsl:value-of select="@type"/></json:string>
    <xsl:apply-templates select="document" mode="json-config">
      <xsl:with-param name="key" select="'document'"/>
    </xsl:apply-templates>
    <json:array key="fragments">
      <xsl:apply-templates select="document/t:fragment" mode="json-config"/>
    </json:array>
    <json:string key="psml">
      <xsl:apply-templates select="node()" mode="psml-source"/>
    </json:string>
  </json:map>
</xsl:template>

<xsl:template match="document" mode="json-config">
  <xsl:param name="key"/>
  <json:map>
    <xsl:if test="$key"><xsl:attribute name="key" select="$key"/></xsl:if>
    <json:string key="type"><xsl:value-of select="@type"/></json:string>
    <json:string key="level"><xsl:value-of select="@level"/></json:string>
    <json:array key="params">
      <xsl:apply-templates select="t:param" mode="json-config"/>
    </json:array>
    <xsl:apply-templates select="metadata" mode="json-document"/>
    <json:array key="structure">
      <xsl:apply-templates select="section|toc" mode="json-document"/>
    </json:array>
    <json:array key="sections">
      <xsl:apply-templates select="section" mode="json-document"/>
    </json:array>
    <json:array key="fragments">
      <xsl:apply-templates select="(section|fragments)/(fragment|media-fragment|properties-fragment|xref-fragment)" mode="json-document"/>
    </json:array>
  </json:map>
</xsl:template>

<xsl:template match="fragment|media-fragment|properties-fragment|xref-fragment" mode="json-config">
  <xsl:param name="key"/>
  <json:map>
    <xsl:if test="$key"><xsl:attribute name="key" select="$key"/></xsl:if>
    <json:string key="id"><xsl:value-of select="@id"/></json:string>
    <json:string key="is"><xsl:value-of select="local-name()"/></json:string>
    <json:string key="type"><xsl:value-of select="@type"/></json:string>
    <json:array key="labels">
      <xsl:for-each select="tokenize(@labels, ',')"><json:string><xsl:value-of select="."/></json:string></xsl:for-each>
    </json:array>
    <xsl:apply-templates select="." mode="json-content"/>
  </json:map>
</xsl:template>

<xsl:template match="t:param" mode="json-config">
  <xsl:param name="key"/>
  <json:map>
    <xsl:if test="$key"><xsl:attribute name="key" select="$key"/></xsl:if>
    <json:string key="name"><xsl:value-of select="@name"/></json:string>
    <json:string key="default"><xsl:value-of select="@default"/></json:string>
    <xsl:if test="@title"><json:string key="title"><xsl:value-of select="@title"/></json:string></xsl:if>
    <xsl:if test="@type"><json:string key="type"><xsl:value-of select="@type"/></json:string></xsl:if>
    <xsl:if test="@description"><json:string key="description"><xsl:value-of select="@description"/></json:string></xsl:if>
  </json:map>
</xsl:template>

<xsl:template match="t:fragment" mode="json-config">
  <xsl:param name="key"/>
  <json:map>
    <xsl:if test="$key"><xsl:attribute name="key" select="$key"/></xsl:if>
    <json:string key="type"><xsl:value-of select="@type"/></json:string>
    <json:string key="title"><xsl:value-of select="@title"/></json:string>
    <json:string key="description"><xsl:value-of select="t:description"/></json:string>
    <json:string key="is"><xsl:value-of select="*[string(namespace-uri(.)) != 'http://pageseeder.com/psml/template']/local-name()"/></json:string>
    <json:array key="labels">
      <xsl:for-each select="tokenize(*/@labels, ',')">
        <json:string><xsl:value-of select="normalize-space(.)" /></json:string>
      </xsl:for-each>
    </json:array>
    <json:array key="params">
      <xsl:apply-templates select="t:param" mode="json-config" />
    </json:array>
    <json:string key="psml">
      <xsl:apply-templates select="*" mode="psml-source"/>
    </json:string>
  </json:map>
</xsl:template>

<xsl:template match="editor-configs" mode="json-config">
  <xsl:param name="key"/>
  <json:map>
    <xsl:if test="$key"><xsl:attribute name="key" select="$key"/></xsl:if>
    <json:array key="properties">
      <xsl:apply-templates select="editor-config[@name='PSMLProperties']/field" mode="json-config"/>
    </json:array>
    <json:array key="metadata">
      <xsl:apply-templates select="editor-config[@name='PSMLMetadata']/field" mode="json-config"/>
    </json:array>
    <json:array key="xrefs">
      <xsl:apply-templates select="editor-config[@name='PSMLXRefs']/xref-config" mode="json-config"/>
    </json:array>
    <json:array key="creation">
      <xsl:apply-templates select="editor-config[@name='PSMLCreation']/field" mode="json-config"/>
    </json:array>
  </json:map>
</xsl:template>

<xsl:template match="editor-config/field" mode="json-config">
  <json:map>
    <json:string key="name"><xsl:value-of select="@name"/></json:string>
    <json:string key="type"><xsl:value-of select="@type"/></json:string>
    <xsl:for-each select="@label|@placeholder|@pattern|@description">
      <json:string key="{name()}"><xsl:value-of select="."/></json:string>
    </xsl:for-each>
    <json:boolean key="autocomplete"><xsl:value-of select="@autocomplete = 'true'"/></json:boolean>
    <json:boolean key="unique"><xsl:value-of select="@unique = 'true'"/></json:boolean>
    <json:boolean key="readonly"><xsl:value-of select="@readonly = 'true'"/></json:boolean>
    <json:boolean key="required"><xsl:value-of select="@required = 'true'"/></json:boolean>
    <xsl:apply-templates select="xref-config" mode="json-config">
      <xsl:with-param name="key" select="'xrefConfig'"/>
    </xsl:apply-templates>
    <xsl:if test="value">
      <json:array key="value">
        <xsl:for-each select="value">
          <json:string><xsl:value-of select="."/></json:string>
        </xsl:for-each>
      </json:array>
    </xsl:if>
    <json:string key="configType"><xsl:value-of select="if (../@name = 'PSMLProperties') then 'properties' else
                                                        if (../@name = 'PSMLMetadata') then 'metadata' else
                                                        if (../@name = 'PSMLXRefs') then 'xrefs' else
                                                        if (../@name = 'PSMLCreation') then 'creation' else 'unknown'" /></json:string>
  </json:map>
</xsl:template>

<xsl:template match="publishing" mode="json-config">
  <json:map key="publishing">
    <!-- TODO JB -->
  </json:map>
</xsl:template>

<xsl:template match="xref-configs" mode="json-config">
  <json:array key="xrefConfigs">
    <xsl:apply-templates select="xref-config" mode="json-config"/>
  </json:array>
</xsl:template>

<xsl:template match="xref-config" mode="json-config">
  <xsl:param name="key"/>
  <json:map>
    <xsl:if test="$key"><xsl:attribute name="key" select="$key"/></xsl:if>
    <xsl:for-each select="@name|@title">
      <json:string key="{name()}"><xsl:value-of select="."/></json:string>
    </xsl:for-each>
    <xsl:if test="@fragmenttype">
      <json:array key="fragmentTypes">
        <xsl:for-each select="tokenize(@fragmenttype, ',')">
          <json:string><xsl:value-of select="." /></json:string>
        </xsl:for-each>
      </json:array>
    </xsl:if>
    <xsl:apply-templates select="xref|target|autosuggest" mode="json-config"/>
  </json:map>
</xsl:template>

<xsl:template match="xref" mode="json-config">
  <json:map key="xref">
    <xsl:for-each select="@display|@frag|@title|@type|@reversetitle">
      <json:string key="{name()}"><xsl:value-of select="."/></json:string>
    </xsl:for-each>
    <json:number key="level"><xsl:value-of select="if (@level and @level castable as xs:int) then @level else 0"/></json:number>
    <xsl:if test="@reverselink">
      <json:boolean key="reverselink"><xsl:value-of select="@reverselink = 'true'"/></json:boolean>
    </xsl:if>
    <xsl:if test="@labels">
      <json:array key="labels">
        <xsl:for-each select="tokenize(@labels, ',')">
          <json:string><xsl:value-of select="." /></json:string>
        </xsl:for-each>
      </json:array>
    </xsl:if>
    <xsl:if test="@optionallabels">
      <json:array key="optionallabels">
        <xsl:for-each select="tokenize(@optionallabels, ',')">
          <json:map>
            <json:string key="name"><xsl:value-of select="."/></json:string>
            <json:string key="type">xref</json:string>
          </json:map>
        </xsl:for-each>
      </json:array>
    </xsl:if>
  </json:map>
</xsl:template>

<xsl:template match="target" mode="json-config">
<json:map key="target">
  <xsl:for-each select="@documenttype|@group|@folder|@filters|@new">
    <json:string key="{name()}"><xsl:value-of select="."/></json:string>
  </xsl:for-each>
  <json:boolean key="self"><xsl:value-of select="@this = 'true'"/></json:boolean>
</json:map>
</xsl:template>

<xsl:template match="autosuggest" mode="json-config">
  <json:map key="autosuggest">
    <xsl:for-each select="@questionfields|@displayfields">
      <json:string key="{name()}"><xsl:value-of select="."/></json:string>
    </xsl:for-each>
  </json:map>
</xsl:template>

</xsl:stylesheet>