<?xml version="1.0"?>
<!--
  Template used to produce an email used to notify the user that their password was updated.

  @version 5.9904
-->
<xsl:stylesheet version="2.0"
        xmlns:f="http://www.pageseeder.com/function"
        xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
        exclude-result-prefixes="#all">

<xsl:import href="_frame.xsl"/>

<!-- Subject and metadata -->
<xsl:template match="notification[@template='verification-code']" mode="meta">
  <title><xsl:value-of select="$appname"/> verification code</title>
</xsl:template>

<!-- Banner -->
<xsl:template match="notification[@template='verification-code']" mode="banner">
  <p wrapper-class="security-wrap"><xsl:value-of select="$appname" /> security</p>
</xsl:template>

<!-- Body content -->
<xsl:template match="notification[@template='verification-code']" mode="body">
  <h3>Hi <xsl:value-of select="member/@firstname" />,</h3>

  <p>Please enter the following verification code to access your <xsl:value-of select="$appname" /> account:</p>

  <p style="font-size:20pt">
    <b style="margin-right:4px"><xsl:value-of select="substring(@code, 1, 3)"/></b><b><xsl:value-of select="substring(@code, 4)"/></b>
  </p>

  <p>If you were not trying to access your account and are seeing this email, your account might have been
  compromised, and we recommend that you reset your password as soon as possible.</p>
</xsl:template>

</xsl:stylesheet>
