<?xml version="1.0"?>
<!--
  Template used for the daily digest notification
-->
<xsl:stylesheet version="2.0"
                xmlns:f="http://www.pageseeder.com/function"
                xmlns:xs="http://www.w3.org/2001/XMLSchema"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:psf="http://www.pageseeder.com/function"
                exclude-result-prefixes="xs psf">
                
<xsl:import href="_text.xsl"/>

<xsl:template match="/notification[@template='reminder-digest']">
  <xsl:text>YOUR TASK/WORKFLOW REMINDERS FOR </xsl:text>
  <xsl:value-of select="format-date(current-date(), '[D] [MNn] [Y0001]')"/>

CHANGE - your options for receiving notifications:
  <xsl:value-of select="concat($linksprefix, '/mygroups')" />
<xsl:if test="comments/@limitreached='true'">

VIEW - all your tasks as there are too many reminders to list:
  <xsl:value-of select="concat($linksprefix, '/mytasks')" />
</xsl:if><xsl:for-each select="comments/comment">
    <xsl:sort select="@due" order="ascending"/>
    <xsl:text>

***********************************************************************</xsl:text>
    <xsl:text>
DUE: </xsl:text>
    <xsl:value-of select="format-dateTime(@due, '[FNn,*-3] [D] [MNn,*-3] [Y0001]')" />
    <xsl:text>     PRIORITY: </xsl:text>
    <xsl:value-of select="@priority" />
    <xsl:text>     STATUS: </xsl:text>
    <xsl:value-of select="@status" />
    <xsl:text>
</xsl:text>
<xsl:value-of select="if (@contentrole='Workflow') then 'DOCUMENT: ' else 'TASK: '" />
    <xsl:value-of select="title" />
    <xsl:text>
GROUP: </xsl:text>
    <xsl:value-of select="group/@name" />
<xsl:text>

VIEW - the full task and context:
  </xsl:text>
  <xsl:choose>
    <xsl:when test="@contentrole='Workflow'">
      <xsl:value-of select="concat($linksprefix, '/workflow?group=', group/@name, '&amp;uri=', context/uri/@id)" />
    </xsl:when>
    <xsl:otherwise>
      <xsl:value-of select="concat($linksprefix, '/comment?group=',  group/@name, '&amp;comment=', @id)" />
    </xsl:otherwise>
  </xsl:choose>
  </xsl:for-each>
  
----------------------------------------------------------------------
This email has been sent to you because you have an account on <xsl:value-of select="$homepage"/>

This is an automatically generated email - please do not reply to this email.
</xsl:template>

</xsl:stylesheet>
