<?xml version="1.0"?>
<!--
  Email sent to the user after a user is created.

  @version 5.9904
-->
<xsl:stylesheet version="2.0"
        xmlns:f="http://www.pageseeder.com/function"
        xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
        exclude-result-prefixes="#all">

<xsl:import href="_frame.xsl"/>

<!-- Subject and metadata -->
<xsl:template match="notification[@template='new-member']" mode="meta">
  <title>Welcome to <xsl:value-of select="$appname" /></title>
</xsl:template>

<!-- Banner -->
<xsl:template match="notification[@template='new-member']" mode="banner">
  <p wrapper-class="membership-wrap"><xsl:value-of select="$appname" /> invitation</p>
</xsl:template>

<!-- Body content -->
<xsl:template match="notification[@template='new-member']" mode="body">
  <h3>Hi <xsl:value-of select="member/@firstname" />,</h3>

  <p class="lead">
  <xsl:choose>
    <xsl:when test="inviter"><b><xsl:value-of select="inviter/fullname"/></b> invited you to use </xsl:when>
    <xsl:otherwise>Welcome to </xsl:otherwise>
  </xsl:choose> <xsl:value-of select="$appname" /> at <a href="{$homepage}"><xsl:value-of select="f:hostname($homepage)" /></a>.</p>

  <p>You must click on the button below to get started before being able to use <xsl:value-of select="$appname" />.</p>
  <xsl:sequence select="f:button(concat($linksprefix, '/getstarted?member=', member/@id, '&amp;token=', @token), 'Get started')"/>

  <p class="last">This link will be valid for the next <xsl:value-of
    select="f:get-expiration(/notification/organization/token[@type='activate-member'], 'P2D')" />.</p>
</xsl:template>

<!-- Footer -->
<xsl:template match="notification[@template='new-member']" mode="footer">
  <xsl:call-template name="noreply"/>
  <p>You have received this email because a <xsl:value-of select="$appname" /> member created an account for you on
  <a href="{$homepage}"><xsl:value-of select="f:hostname($homepage)"/></a>.</p>
  <xsl:if test="organization/footer/@text">
    <p><xsl:value-of select="organization/footer/@text"/></p>
  </xsl:if>
</xsl:template>

</xsl:stylesheet>
