<?xml version="1.0"?>
<!--
  Email sent to the user after a new comment is added.

  @version 5.9904
-->
<xsl:stylesheet version="2.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:f="http://www.pageseeder.com/function"
                xmlns:xs="http://www.w3.org/2001/XMLSchema"
                exclude-result-prefixes="#all">

<xsl:import href="_frame.xsl"/>

<!-- Subject and metadata -->
<xsl:template match="notification[@template='new-comment']" mode="meta">
  <meta name="replyto-email"         content="{comment/@id}-reply@{$emaildomain}" />
  <meta name="replyto-name"          content="Reply to {group/@name} group" />
  <meta name="list-id"               content="{group/@name}.{$emaildomain}" />
  <meta name="list-name"             content="{group/@description}" />
  <meta name="list-help"             content="{$linksprefix}/home?group={group/@name}" />
  <meta name="list-unsubscribe"      content="{$linksprefix}/unsubscribe?group={group/@name}&amp;{if
    (@announcement = 'true') then 'deregister=true' else 'notification=none'}&amp;token={@unsubscribetoken}" />
  <meta name="list-unsubscribe-post" content="List-Unsubscribe=One-Click" />
  <meta name="list-post"             content="{$linksprefix}/newcomment?group={group/@name}" />
  <meta name="list-archive"          content="{$linksprefix}/comments?group={group/@name}" />
  <meta name="message-id"            content="{comment/@id}.comment@{$emaildomain}" />
  <xsl:if test="comment/@id!=comment/@discussionid">
    <meta name="in-reply-to" content="{comment/@discussionid}.comment@{$emaildomain}" />
  </xsl:if>
  <title>
    <xsl:text>[</xsl:text>
    <xsl:value-of select="group/@name" />
    <xsl:text>] </xsl:text>
    <xsl:choose>
      <xsl:when test="comment/@status and comment/@contentrole='Workflow'">(Workflow) </xsl:when>
      <xsl:when test="comment/@status">(Task) </xsl:when>
    </xsl:choose>
    <xsl:value-of select="comment/title" />
  </title>
</xsl:template>

<!-- Task banner -->
<xsl:template match="notification[@template='new-comment']" mode="banner">
  <xsl:if test="@taskchanged = 'true' or not(empty(comment/@status | comment/@priority | comment/assignedto | comment/@due))">
    <xsl:apply-templates select="comment" mode="task"/>
  </xsl:if>
</xsl:template>

<!-- Body content -->
<xsl:template match="notification[@template='new-comment']" mode="body">
  <!-- Document version -->
  <xsl:if test="@modified = 'true'">
    <table class="note"><tr>
      <td>This <xsl:value-of select="if (empty(comment/@status)) then 'comment' else 'task'"/> has been modified.</td>
      <td class="text-right"><xsl:for-each select="comment/author">Original author: <b><xsl:value-of select="fullname"/></b></xsl:for-each></td>
    </tr></table>
  </xsl:if>

  <!-- Status changed -->
  <xsl:if test="@taskchanged = 'true'">
    <table class="note"><tr>
      <td>The task details above have been changed.</td>
      <td class="text-right"><xsl:for-each select="comment/author">Original author: <b><xsl:value-of select="fullname"/></b></xsl:for-each></td>
    </tr></table>
  </xsl:if>

  <!-- Broadcast All -->
  <xsl:if test="@announcement = 'true'">
    <table class="announcement"><tr><td>This comment has been sent to you regardless of your <xsl:value-of select="$appname" /> notification
    settings because it is an announcement.</td></tr></table>
  </xsl:if>

  <!-- Document Context -->
  <xsl:apply-templates select="comment" mode="context" />

  <!-- Check for recipients -->
  <xsl:apply-templates select="recipients" />

  <!-- Contents -->
  <xsl:copy-of select="comment/content[@type = 'application/xhtml+xml']/node()" />

  <!-- Labels -->
  <xsl:apply-templates select="comment" mode="labels" />

  <!-- File Attachments -->
  <xsl:apply-templates select="comment" mode="attachments" />

  <!-- More info -->
  <h4 class="subtitle">&#xA0;</h4>
  <p>You can reply to this message
    <xsl:choose>
      <xsl:when test="comment/@contentrole='Workflow'">
        <xsl:sequence select="f:link(concat($linksprefix, '/workflow?group=', group/@name, '&amp;uri=', comment/context/uri/@id), 'online')"/>
      </xsl:when>
      <xsl:otherwise>
        <xsl:sequence select="f:link(concat($linksprefix, '/comment?group=', group/@name, '&amp;comment=', comment/@id), 'online')"/>
      </xsl:otherwise>
    </xsl:choose>
    or directly by typing your response above this email.</p>

  <xsl:if test="comment/@due">
    <p class="timezone">Dates and times display for timezone <xsl:value-of select="format-date(current-date(), '[z]')"/></p>
  </xsl:if>
</xsl:template>

<!-- ====================================================================== -->
<!-- Supporting templates -->
<!-- ====================================================================== -->

<xsl:template match="recipients">
<xsl:if test="recipient">
  <table class="recipients"><tr><td>
    <xsl:for-each select="recipient">
      <p>
      <xsl:value-of select="upper-case(@type)" />
      <xsl:text>: </xsl:text>
      <xsl:if test="@name"><xsl:value-of select="concat(@name, ' ')" /></xsl:if>
      <xsl:value-of select="@email" />
      </p>
    </xsl:for-each>
  </td></tr></table>
</xsl:if>
</xsl:template>

<xsl:template match="comment" mode="context">
  <xsl:if test="context/uri">
    <table width="100%" cellpadding="0" cellspacing="0" border="0" class="message-context">
      <tr>
        <td class="message-context_td">
        <img src="{$images-url}/{f:mediatype-icon(context/uri)}" class="is-icon" width="20" style="vertical-align: bottom;" border="0"/>
        <xsl:choose>
          <xsl:when test="context/uri/@external = 'true'">
            <b>URL: </b>
            <xsl:sequence select="f:link(f:url(context/uri), context/uri/displaytitle)" />
          </xsl:when>
          <xsl:otherwise>
            <b>Document: </b>
            <xsl:sequence select="f:link(concat($linksprefix, '/uri?group=', ../group/@name, '&amp;uri=', context/uri/@id,
            if (context/@fragment) then concat('&amp;fragment=',encode-for-uri(context/@fragment)) else ''), context/uri/displaytitle)" />
          </xsl:otherwise>
        </xsl:choose>
      </td></tr>
    </table>
  </xsl:if>
</xsl:template>

<xsl:template match="comment" mode="task">
<table width="100%" cellpadding="0" cellspacing="0" border="0" wrapper-class="task-wrap"><tr>
  <td class="task-cell">
    <div class="task-property">Status </div>
    <img src="{$images-url}/{f:status-icon(@status)}" class="is-task-icon" width="16" border="0" alt="{@status}" />
    <xsl:text> </xsl:text>
    <b class="task-value"><xsl:value-of select="@status" /></b>
  </td>
  <xsl:if test="@priority">
    <td class="task-cell">
      <div class="task-property">Priority </div>
      <img src="{$images-url}/{f:priority-icon(@priority)}" class="is-task-icon" width="16"  border="0" alt="{@priority}" />
      <xsl:text> </xsl:text>
      <b class="task-value"><xsl:value-of select="@priority" /></b>
    </td>
  </xsl:if>
  <xsl:if test="assignedto">
    <td class="task-cell">
      <div class="task-property">Assigned to </div>
      <b class="task-value"><xsl:value-of select="assignedto/fullname" /></b>
    </td>
  </xsl:if>
  <xsl:if test="@due">
    <td class="task-cell">
      <div class="task-property">Due date </div>
      <b class="task-value"><xsl:value-of select="format-dateTime(xs:dateTime(@due), '[D] [MNn,*-3] [Y]')" /></b>
    </td>
  </xsl:if>
  <xsl:if test="not(@due) or not(assignedto) or not(@priority)">
    <td><!-- --></td>
  </xsl:if>
</tr></table>
</xsl:template>

<xsl:template match="comment" mode="labels">
  <xsl:if test="labels">
    <xsl:sequence select="f:labels($images-url, labels)"/>
  </xsl:if>
</xsl:template>

<xsl:template match="comment" mode="attachments">
<xsl:if test="attachment/uri">
  <h4 class="subtitle">File attachments</h4>
  <table width="100%" cellpadding="2" cellspacing="0" border="0"><tbody>
    <xsl:for-each select="attachment/uri">
      <xsl:sort select="lower-case(displaytitle)"/>
      <xsl:variable name="fragment" select="../@fragment"/>
      <tr>
        <td class="attachment-icon"><img src="{$images-url}/{f:mediatype-icon(.)}" width="20" border="0" alt="" /></td>
        <xsl:variable name="view"      select="if ($fragment and $fragment != 'default')
            then concat($linksprefix, '/uri?group=', ../../../group/@name, '&amp;uri=', @id, '&amp;fragment=', $fragment)
            else concat($linksprefix, '/uri?group=', ../../../group/@name, '&amp;uri=', @id)" />
        <xsl:variable name="download" select="concat($linksprefix, '/download?uri=', @id)" />
        <td class="attachment-title"><xsl:sequence select="f:link($view, displaytitle)" />
        <xsl:if test="$fragment and $fragment != 'default'">
          (<xsl:value-of select="if (starts-with($fragment, 'page='))
              then concat('Page ', substring-after($fragment, 'page='))
              else concat('Fragment #', $fragment)"/>)
        </xsl:if>
        </td>
        <td class="attachment-download">
          <xsl:choose>
            <xsl:when test="@mediatype = 'application/vnd.pageseeder.psml+xml' or @external='true'">
              <xsl:sequence select="f:link($view, 'View')" />
            </xsl:when>
            <xsl:when test="not(@mediatype = 'folder')">
              <xsl:sequence select="f:link($download, 'Download')" />
            </xsl:when>
          </xsl:choose>
        </td>
      </tr>
    </xsl:for-each>
  </tbody></table>
</xsl:if>
</xsl:template>

<!--
  Find the name of the icon corresponding to the status provided

  @param status the status

  @param the filename of the icon
 -->
<xsl:function name="f:status-icon">
<xsl:param name="status"/>
<xsl:choose>
  <xsl:when test="lower-case($status) = 'closed'">task-closed.png</xsl:when>
  <xsl:when test="lower-case($status) = 'resolved'">task-resolved.png</xsl:when>
  <xsl:when test="lower-case($status) = 'complete'">task-resolved.png</xsl:when>
  <xsl:when test="lower-case($status) = 'approved'">task-approved.png</xsl:when>
  <xsl:otherwise>task-open.png</xsl:otherwise>
</xsl:choose>
</xsl:function>

<!--
  Find the name of the icon corresponding to the priority provided

  @param priority the priority

  @param the filename of the icon
 -->
<xsl:function name="f:priority-icon">
<xsl:param name="priority"/>
<xsl:choose>
  <xsl:when test="lower-case($priority) = 'high'">task-priority-1.png</xsl:when>
  <xsl:when test="lower-case($priority) = 'medium'">task-priority-2.png</xsl:when>
  <xsl:when test="lower-case($priority) = 'low'">task-priority-3.png</xsl:when>
  <xsl:otherwise>task-priority-4.png</xsl:otherwise>
</xsl:choose>
</xsl:function>

</xsl:stylesheet>
