<?xml version="1.0"?>
<!--
  Template used for the daily digest notification

  @version 5.9904
-->
<xsl:stylesheet version="2.0"
                xmlns:xs="http://www.w3.org/2001/XMLSchema"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:f="http://www.pageseeder.com/function"
                exclude-result-prefixes="#all">

<xsl:import href="_frame.xsl"/>

<xsl:variable name="frequency" select="if (/notification/@frequency='daily') then 'Daily' else 'Weekly'" />

<!-- Subject and metadata -->
<xsl:template match="notification[@template='comment-digest']" mode="meta">
  <title>[<xsl:value-of select="group/@name" />] <xsl:value-of select="$frequency"/> digest</title>
</xsl:template>

<!-- Body content -->
<xsl:template match="notification[@template='comment-digest']" mode="banner">
  <p wrapper-class="digest-wrap"><xsl:value-of select="$frequency"/> digest for
  <xsl:if test="/notification/@frequency='weekly'">week ending </xsl:if>
  <b><xsl:value-of select="format-date(current-date(), '[D] [MNn] [Y0001]')"/></b></p>
</xsl:template>

<!-- Body content -->
<xsl:template match="notification[@template='comment-digest']" mode="body">
  <xsl:apply-templates select="comments" mode="html" />
</xsl:template>

<!-- ===================================================================================== -->
<!-- Comments -->
<!-- ===================================================================================== -->

<xsl:template match="comments" mode="html">
  <p>The <b><xsl:value-of select="count(comment)"/></b> comments below have been added to
  the group <i><xsl:value-of select="../group/@name" /></i> in the last
  <xsl:choose>
    <xsl:when test="/notification/@frequency='weekly'">7 days</xsl:when>
    <xsl:otherwise>24 hours</xsl:otherwise>
  </xsl:choose>.</p>

  <div class="digest-summary">
    <table cellspacing="0" cellpadding="0">
      <xsl:for-each-group select="comment" group-by="@discussionid">
        <xsl:sort select="@created" order="descending"/>
        <tr>
          <th style="width:80px">&#xa0;</th>
          <td><b><xsl:value-of select="title" /></b></td>
        </tr>
        <xsl:for-each select="current-group()">
          <xsl:sort select="@created" order="descending"/>
          <tr>
            <th>
              <xsl:if test="/notification/@frequency='weekly'"><div class="weekday"><xsl:value-of select="format-dateTime(@created, '[F]')" /></div></xsl:if>
              <xsl:value-of select="translate(format-dateTime(@created, '[h]:[m01] [PN]'),'.','')"/>
            </th>
            <td><a href="#ps-{@discussionid}-{position()}"><xsl:value-of select="if (position() = last()) then 'Comment' else 'Reply'"/></a> by <i><xsl:value-of select="author/fullname" /></i></td>
          </tr>
        </xsl:for-each>
      </xsl:for-each-group>
    </table>
  </div>

  <table cellspacing="0" cellpadding="0" style="vertical-align:top; width:100%; border-collapse: collapse; background: white">
    <xsl:for-each-group select="comment" group-by="@discussionid">
      <xsl:sort select="@created" order="descending"/>
      <xsl:variable name="notification" select="ancestor::notification"/>
      <xsl:variable name="href" select="concat($linksprefix, '/comment?group=', $notification/group/@name, '&amp;comment=', @id)"/>
      <tr>
        <th class="digest-title"><a name="ps-{@discussionid}-{position()}" id="ps-{@discussionid}-{position()}"/></th>
        <th class="digest-title"><a href="{$linksprefix}/comment?group={$notification/group/@name}&amp;comment={@id}"><xsl:value-of select="title" /></a></th>
      </tr>
      <xsl:for-each select="current-group()">
        <xsl:sort select="@created" order="descending"/>
        <tr>
          <th class="digest-time">
            <xsl:if test="/notification/@frequency='weekly'"><div class="weekday"><xsl:value-of select="format-dateTime(@created, '[F]')" /></div></xsl:if>
            <xsl:value-of select="format-dateTime(@created, '[h]:[m01]')"/>
            <div class="ampm"><xsl:value-of select="translate(format-dateTime(@created, '[PN]'), '.','')"/></div>
          </th>
          <td class="digest-comment">
            <xsl:apply-templates select="." mode="digest-html" />
          </td>
        </tr>
      </xsl:for-each>
      <tr>
        <td></td>
        <td>
          <p style="color: #999999"><i>You can reply to this comment <xsl:text/>
            <xsl:sequence select="f:link($href, 'online')" />
            <xsl:if test="$emaildomain">
              <xsl:variable name="email">
                <xsl:value-of select="@id" />
                <xsl:text>-reply@</xsl:text>
                <xsl:value-of select="$emaildomain" />
              </xsl:variable>
              <xsl:text> or by email at </xsl:text>
              <xsl:sequence select="f:link(concat('mailto:', $email, '?subject=Reply'), $email)" />
            </xsl:if>.<xsl:text/>
          </i></p>
        </td>
      </tr>
      <tr>
        <td colspan="2">&#160;</td>
      </tr>
    </xsl:for-each-group>
  </table>

  <p class="timezone">Dates and times display for timezone <xsl:value-of select="format-date(current-date(), '[z]')"/></p>
</xsl:template>

<!-- ===================================================================================== -->
<!-- Single Message -->
<!-- ===================================================================================== -->
<xsl:template match="comment" mode="digest-html">
  <table cellspacing="0" cellpadding="0" style="vertical-align:top; width:100%; border-collapse: collapse; background: white">
    <tbody>
      <!-- If it's a task -->
      <xsl:if test="@status">
        <tr>
          <td style="background:#E5F4FF;font-size: 13px; padding: 10px 2px">
            <table cellspacing="0" cellpadding="0" style="vertical-align:top; width:100%; border-collapse: collapse;">
                <tr><td>
            <td class="task-cell">
              <div class="task-property">Status </div>
<!--              <img src="{$images-url}/{f:status-icon(@status)}" class="is-task-icon" border="0" alt="{@status}" />-->
              <xsl:text> </xsl:text>
              <b class="task-value"><xsl:value-of select="@status" /></b>
            </td>
            <xsl:if test="@priority">
              <td class="task-cell">
                <div class="task-property">Priority </div>
<!--                <img src="{$images-url}/{f:priority-icon(@priority)}" class="is-task-icon" border="0" alt="{@priority}" />-->
                <xsl:text> </xsl:text>
                <b class="task-value"><xsl:value-of select="@priority" /></b>
              </td>
            </xsl:if>
            <xsl:if test="assignedto">
              <td class="task-cell">
                <div class="task-property">Assigned to </div>
                <b class="task-value"><xsl:value-of select="assignedto/fullname" /></b>
              </td>
            </xsl:if>
            <xsl:if test="@due">
              <td class="task-cell">
                <div class="task-property">Due date </div>
                <b class="task-value"><xsl:value-of select="format-dateTime(xs:dateTime(@due), '[D] [MNn,*-3] [Y]')" /></b>
              </td>
            </xsl:if>
                </td></tr></table>
          </td>
        </tr>
      </xsl:if>

      <!-- Author and content -->
      <tr>
        <td class="digest-author">
          <b><xsl:value-of select="author/fullname" /></b>
        </td>
      </tr>
      <tr>
        <td class="digest-content">
          <xsl:copy-of select="content[@type = 'application/xhtml+xml']/node()" />
        </td>
      </tr>

      <xsl:variable name="notification" select="ancestor::notification"/>

      <xsl:if test="context/uri">
        <tr>
          <td class="digest-context-title"><b>Context</b></td>
        </tr>
        <tr>
          <td class="digest-context">
            <xsl:sequence select="f:link(concat($linksprefix, '/uri?group=', $notification/group/@name, '&amp;uri=', context/uri/@id,
              if (context/@fragment) then concat('&amp;fragment=',encode-for-uri(context/@fragment)) else ''), context/uri/displaytitle)" />
          </td>
        </tr>
      </xsl:if>

      <xsl:variable name="attachments" select="attachment/uri" />
      <xsl:if test="$attachments">
        <tr>
          <td class="digest-attachments-title">
            <b>Attachment<xsl:value-of select="if (count($attachments) > 1) then 's' else ''" /></b>
          </td>
        </tr>
        <tr>
          <td class="digest-attachments">
            <table width="100%" cellpadding="2" cellspacing="0" border="0"><tbody>
              <xsl:for-each select="$attachments">
                <tr>
                  <td class="attachment-icon"><img src="{$images-url}/{f:mediatype-icon(.)}" border="0" alt="" /></td>
                  <xsl:variable name="view"     select="concat($linksprefix, '/uri?group=', $notification/group/@name, '&amp;uri=', @id)" />
                  <xsl:variable name="download" select="concat($linksprefix, '/download?uri=', @id)" />
                  <td class="attachment-title"><xsl:sequence select="f:link($view, displaytitle)" /></td>
                  <td class="attachment-download">
                    <xsl:if test="not(@mediatype = 'folder')">
                      <xsl:sequence select="f:link($download, 'Download')" />
                    </xsl:if>
                  </td>
                </tr>
              </xsl:for-each>
            </tbody></table>
          </td>
        </tr>
      </xsl:if>
    </tbody>
  </table>
</xsl:template>

</xsl:stylesheet>
