<?xml version="1.0"?>
<!--
  Define useful functions for plain text emails
-->
<xsl:stylesheet version="2.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:xs="http://www.w3.org/2001/XMLSchema"
                xmlns:f="http://www.pageseeder.com/function"
                exclude-result-prefixes="#all">

<xsl:output encoding="UTF-8" method="text" />

<!-- email domain -->
<xsl:variable name="emaildomain"  select="/notification/@emaildomain"/>

<!-- links prefix -->
<xsl:variable name="linksprefix"  select="if (/notification/organization/links/@prefix) then /notification/organization/links/@prefix else
                                          if (/notification/@hosturl) then concat(/notification/@hosturl, '/email') else 'https://ps.pageseeder.com/ps/email'"/>

<!-- homepage -->
<xsl:variable name="homepage"  select="if (/notification/organization/application/@homepage) then /notification/organization/application/@homepage else
                                       if (/notification/@hosturl) then concat(/notification/@hosturl, '/') else 'https://ps.pageseeder.com/ps'"/>

<!-- application name -->
<xsl:variable name="appname"  select="if (/notification/organization/application/@name) then /notification/organization/application/@name else 'PageSeeder'"/>

<!--
   @param uri The attachment URI
   @return The link to the attachment
-->
<xsl:function name="f:attachment-link" as="xs:string">
  <xsl:param name="uri"/>
  <xsl:variable name="n" select="$uri/ancestor::notification"/>
  <xsl:value-of select="concat($linksprefix, '/uri?group=', $n/group/@name, '&amp;uri=', $uri/@id)" />
</xsl:function>

<!--
   @param uri The comment author
   @return The name and email of the author if available
-->
<xsl:function name="f:author" as="xs:string">
  <xsl:param name="author"/>
  <xsl:value-of select="$author/fullname,$author/@email" separator=", "/>
</xsl:function>

<!--
  @param context The comment context element
  @return the context string to display
-->
<xsl:function name="f:context-link" as="xs:string">
  <xsl:param name="context" />
  <xsl:for-each select="$context">
    <xsl:choose>
      <xsl:when test="group">
        <xsl:value-of select="concat($linksprefix, '/comments?group=', group/@name)"/>
      </xsl:when>
      <xsl:otherwise>
        <xsl:value-of select="concat($linksprefix, '/uri?uri=', uri/@id,
          if (@fragment) then concat('&amp;fragment=',encode-for-uri(@fragment)) else '')"/>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:for-each>
</xsl:function>

<!--
  @param context The comment context element
  @return the context string to display
-->
<xsl:function name="f:context" as="xs:string*">
  <xsl:param name="context" />
  <xsl:for-each select="$context">
    <xsl:variable name="location-name">
      <xsl:choose>
        <xsl:when test="starts-with(@fragment, 'page=')">
          <xsl:value-of select="concat('PAGE ', replace(@fragment, '(^page=)|(&amp;.*?$)', ''))"/>
        </xsl:when>
        <xsl:when test="@fragment = 'default'"></xsl:when>
        <xsl:when test="contains(@fragment, '//Discussion')">
          <xsl:value-of select="concat('LOCATION: ', substring-before(@fragment, '//Discussion'))"/>
        </xsl:when>
        <xsl:when test="@fragment">
          <xsl:value-of select="concat('LOCATION: ', @fragment)"/>
        </xsl:when>
      </xsl:choose>
    </xsl:variable>
    <xsl:choose>
      <xsl:when test="group">Group <xsl:value-of select="group/@name" /></xsl:when>
      <xsl:when test="uri"><xsl:value-of select="uri/displaytitle" /></xsl:when>
    </xsl:choose>
    <xsl:text> </xsl:text>
    <xsl:value-of select="$location-name" />
  </xsl:for-each>
</xsl:function>

<!--
  Return the URL for an external URI

  @param uri  The external URI
-->
<xsl:function name="f:url">
  <xsl:param name="uri" />
  <xsl:value-of select="$uri/@scheme" />
  <xsl:text>://</xsl:text>
  <xsl:value-of select="$uri/@host" />
  <xsl:if test="not($uri/@scheme = 'http' and $uri/@port = '80') and not($uri/@scheme = 'https' and $uri/@port = '443')">
    <xsl:text>:</xsl:text>
    <xsl:value-of select="$uri/@port" />
  </xsl:if>
  <xsl:value-of select="$uri/@path" />
</xsl:function>

  <!--
    Finds the specified strings in the given text.

    @param strings the strings to look for in the text
    @param text    The text to search

    @return the strings that where found in the texts.
  -->
<xsl:function name="f:find-string" as="xs:string">
  <xsl:param name="strings"/>
  <xsl:param name="text"/>
  <xsl:variable name="upper" select="upper-case($text)"/>
  <xsl:for-each select="tokenize($strings, ',')">
    <xsl:if test="contains($upper, normalize-space(upper-case(.)))">
      <xsl:value-of select="normalize-space(.)" />
    </xsl:if>
  </xsl:for-each>
</xsl:function>

<xsl:function name="f:comment-content"  as="xs:string*">
  <xsl:param name="comment"/>
  <xsl:for-each select="$comment/content[contains(@type,'text/plain')]">
    <xsl:value-of select="." />
    <xsl:text>
  </xsl:text>
</xsl:for-each>
</xsl:function>

</xsl:stylesheet>
