<!--
  Indexing transformations for PageSeeder comments

  The source XML follows the structure below:

  ```
    <index-data mediatype="application/vnd.pageseeder.comment+xml">
      <comment> ... </comment>
    </index-data>
  ```

  @author Christophe Lauret
  @author Jean-Baptiste Reure

  @version 5.9000
-->
<xsl:transform  xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="2.0"
                xmlns:psf="http://www.pageseeder.com/function"
                xmlns:xs="http://www.w3.org/2001/XMLSchema"
                exclude-result-prefixes="#all">

<!-- Contains commons fields -->
<xsl:import href="common.xsl" />

<!-- Using Flint Index Document 5.0 -->
<xsl:output method="xml" indent="no" encoding="utf-8"
            doctype-public="-//Weborganic//DTD::Flint Index Documents 5.0//EN"
            doctype-system="http://weborganic.org/schema/flint/index-documents-5.0.dtd"/>

<!-- Sent by the index processor -->
<xsl:param name="psid-field-name" select="'psid'" />
<xsl:param name="psid-field-value" />

<!-- Lucene documents -->
<xsl:template match="/index-data">
  <documents version="5.0">
    <document>
      <xsl:apply-templates select="comment"                  mode="ixml"/>
      <xsl:apply-templates select="publications/publication" mode="ixml"/>
    </document>
  </documents>
</xsl:template>

<!--
  Generate the fields specific to a task from a `comment`
-->
<xsl:template match="comment" mode="ixml">

    <!-- Core fields -->
    <xsl:sequence select="psf:ps-id($psid-field-name, @id)"/>
    <xsl:sequence select="psf:ps-title(title)"/>
    <xsl:sequence select="psf:ps-type('comment')"/>
    <xsl:sequence select="psf:ps-subtype(if (@type) then @type else 'comment')"/>
    <xsl:sequence select="psf:ps-mediatype('application/vnd.pageseeder.comment+xml')"/>
    <xsl:sequence select="psf:ps-modifieddate(xs:dateTime(if (modifiedby/@date) then modifiedby/@date else @created))"/>

    <!-- Comments fields -->
    <xsl:sequence select="psf:ps-discussionid(@discussionid)"/>
    <xsl:sequence select="psf:ps-labels(labels)"/>
    <xsl:sequence select="psf:ps-createddate(@created)"/>
    <xsl:sequence select="psf:ps-author(author/fullname)"/>
    <xsl:if test="author/@id">
      <xsl:sequence select="psf:ps-authorid(author/@id)"/>
    </xsl:if>
    <xsl:sequence select="psf:ps-contextexternal(context/uri/@external = 'true')"/>
    <xsl:sequence select="psf:ps-contexturi(context/uri)"/>
    <xsl:sequence select="psf:ps-contextfragment(if (context/@fragment) then context/@fragment else 'default')"/>

    <!-- Comment task specific fields -->
    <xsl:sequence select="psf:ps-comment-status(@status)"/>
    <xsl:sequence select="psf:ps-comment-duedate(@due)"/>
    <xsl:sequence select="psf:ps-comment-priority(@priority)"/>
    <xsl:sequence select="psf:ps-comment-assignedto(assignedto/fullname)"/>
    <xsl:if test="assignedto/@id">
      <xsl:sequence select="psf:ps-comment-assignedtoid(assignedto/@id)"/>
    </xsl:if>

    <!-- Comment properties -->
    <xsl:for-each select="descendant::property">
      <xsl:sequence select="psf:ps-property(.)"/>
    </xsl:for-each>

    <!-- Context -->
    <xsl:if test="context/uri">
      <xsl:sequence select="psf:ps-folder(replace(context/uri/@decodedpath, '/[^/]*?$', ''))"/>
    </xsl:if>

    <!-- Content -->
    <xsl:sequence select="psf:ps-content(normalize-space(string-join(content//text(), ' ')))"/>

    <!-- Any other custom fields -->
    <xsl:call-template name="custom-fields" />

</xsl:template>

<!-- TEMPLATES LEFT BLANK FOR CUSTOMISATION =============================== -->

<!--
  Use this template to add custom fields for each comment

  <field store="true" name="my_field">field contents</field>

  @context comment
-->
<xsl:template name="custom-fields"/>

</xsl:transform>